package com.bcxin.tenant.domain.repositories.dtos;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class OrganizationDetailDto extends OrganizationDto {
    private ContactDto administrator;
    private ContactDto generalManager;
    private ContactDto deputyGeneralManager;

    public OrganizationDetailDto(String id, String name, String unifySocialCreditCode) {
        super(id,name,unifySocialCreditCode);
    }

    public OrganizationDetailDto(String id, String code, String name,
                                 LocationValueType placeOfRegister,
                                 LocationValueType placeOfBusiness,
                                 String industryCode,String institutionalCode,
                                 String logoPath,
                                 String sysName,
                                 String description,
                                 Double longitude,
                                 Double latitude,
                                 Date createdTime,
                                 Date lastUpdatedTime,
                                 String unifySocialCreditCode,
                                 String unifySocialCreditCodeFile,
                                 ContactDto administrator,
                                 ContactDto generalManager,
                                 ContactDto deputyGeneralManager,
                                 String lonLatJson) {
        super(id,code,name,placeOfRegister,placeOfBusiness,industryCode,institutionalCode,
                logoPath,sysName,description,longitude,latitude,createdTime,lastUpdatedTime,unifySocialCreditCode,
                unifySocialCreditCodeFile,lonLatJson);
        this.setAdministrator(administrator);
        this.setGeneralManager(generalManager);
        this.setDeputyGeneralManager(deputyGeneralManager);
    }


    /**
     *
     * @param id
     * @param code
     * @param name
     * @param placeOfRegister
     * @param placeOfBusiness
     * @param industryCode
     * @param institutionalCode
     * @param logoPath
     * @param createdTime 在Hibernate中, 我指定的是Timestamp,但是这边却只能使用Date
     * @param lastUpdatedTime 在Hibernate中, 我指定的是Timestamp,但是这边却只能使用Date
     * @return
     */
    public static OrganizationDetailDto create(String id, String code, String name,
                                               LocationValueType placeOfRegister,
                                               LocationValueType placeOfBusiness,
                                               String industryCode,String institutionalCode,
                                               String logoPath,
                                               String sysName,
                                               String description,
                                               Double longitude,
                                               Double latitude,
                                               Date createdTime,
                                               Date lastUpdatedTime,
                                               String unifySocialCreditCode,
                                               String unifySocialCreditCodeFile,
                                               ContactDto administrator,
                                               ContactDto generalManager,
                                               ContactDto deputyGeneralManager,
                                               String lonLatJson) {
        OrganizationDetailDto organizationDto = new OrganizationDetailDto(
                id,
                code,
                name,
                placeOfRegister,
                placeOfBusiness,
                industryCode,
                institutionalCode,
                logoPath,
                sysName,
                description,
                longitude,
                latitude,
                createdTime,
                lastUpdatedTime,
                unifySocialCreditCode,
                unifySocialCreditCodeFile,
                administrator,
                generalManager,
                deputyGeneralManager,
                lonLatJson);

        return organizationDto;
    }

    @Data
    public static class ContactDto implements Serializable {
        /**
         * 姓名
         */
        private String name;
        /**
         * 手机
         */
        private String telephone;
        /**
         * 证件类型
         */
        private CredentialType credentialType;
        /**
         * 证件号
         */
        private String credentialNumber;
    }

}
