package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.XlcpEntity;

import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface XlcpRepository extends EntityRepository<XlcpEntity,String> {

    XlcpEntity getByOrganIdAndId(String organizationId, String id);

    List<XlcpEntity> getByOrganIdAndIds(String organizationId, List<String> ids);

    List<XlcpEntity> getByOrganIdAndEmployeeId(String organizationId, String employeeId);

    List<XlcpEntity> countWithinTheDeadlineOfEmployeeId(String organizationId, Date lastTime);

    Collection<XlcpEntity> findByEmployeeIdAndProjectName(String employeeId, String projectName);
    Collection<XlcpEntity> findByTimeAndLikeName(Date lastTime, String keyword);

}
