package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.tenant.domain.entities.TenantUserCredentialDetailsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;

import java.util.Collection;
import java.util.List;

public interface TenantUserRepository extends EntityRepository<TenantUserEntity,String> {
    TenantUserEntity getByIdNum(String idNum, CredentialType credentialType);

    TenantUserEntity getByThirdPartyLoginNo(String thirdPartyLoginNo);

    Collection<TenantUserEntity> findAllByTelephones(Collection<String> telephones);

    Collection<TenantUserEntity> getByIds(Collection<String> ids);

    Collection<TenantUserEntity> findAllByNumbers(Collection<String> numbers);

    //通过身份证查询没有关联的证书信息
    Collection<TenantUserCredentialDetailsEntity> findNotAssociatedCredentialDetailsByNumbers(String numbers);

    //void updateCredentialTenantUserId(List<String> ids,TenantUserEntity tenantUserId);
    void updateCredentialDetailsTenantUserId(Collection<String> idNums,String tenantUserId);

    void updateCredentialNameByTenantUserId(String tenantUserId, String name);
}
