package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.tenant.domain.entities.ExternalGroupEntity;
import com.bcxin.tenant.domain.entities.ExternalMemberEntity;
import com.bcxin.tenant.domain.repositories.criterias.ExternalMemberSearchCriteria;
import com.bcxin.tenant.domain.repositories.dtos.ExternalMemberDTO;

import java.util.Collection;
import java.util.Optional;

public interface ExternalMemberRepository extends EntityRepository<ExternalMemberEntity,String> {
    Collection<ExternalMemberEntity> getByIds(Collection<String> ids);

    ExternalMemberEntity getByTenantUserIdAndRefNumAndRefType(String tenantUserId, String refNum, ResourceReferenceType refType);

    Collection<String> getAdminIds(String orgId);
}
