package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import lombok.Getter;

@Getter
public class TenantCheckStatusChangedEvent extends DomainEventAbstract<TenantUserEntity> {
    private final String IdCardNum;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param data
     * @param idCardNum
     */
    public TenantCheckStatusChangedEvent(TenantUserEntity data, String idCardNum) {
        super(data);
        IdCardNum = idCardNum;
    }

    public static TenantCheckStatusChangedEvent create(TenantUserEntity tenantUser, String idCardNum) {
        return new TenantCheckStatusChangedEvent(tenantUser, idCardNum);
    }
}
