package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import lombok.Getter;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
public class EmployeeUpdatedEvent extends DomainEventAbstract<EmployeeEntity> {
    private final EmployeeEventType eventType;
    private final Timestamp eventTime;
    private final String note;

    public EmployeeUpdatedEvent(EmployeeEntity employee, EmployeeEventType eventType, Timestamp eventTime, String note) {
        super(employee);
        this.eventType = eventType;

        if (eventTime == null) {
            this.eventTime = Timestamp.from(Instant.now());
        } else {
            this.eventTime = eventTime;
        }

        this.note = note;
    }

    public static EmployeeUpdatedEvent create(EmployeeEntity employee,
                                              EmployeeEventType eventType,
                                              Timestamp eventTime,
                                              String note) {
        return new EmployeeUpdatedEvent(employee, eventType, eventTime, note);
    }
}
