package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import lombok.Data;
import lombok.Getter;

import javax.persistence.Column;
import java.sql.Timestamp;
import java.time.Instant;

@Data
public abstract class ResourceEntityAbstract extends EntityAbstract {
    @Column(nullable = false, name = "created_time")
    private Timestamp createdTime;

    @Column(nullable = true, name = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @Column(nullable = false,name = "reference_type")
    private ResourceReferenceType referenceType;

    /**
     *  目前均指企业的Id
     */
    @Column(nullable = false,name = "reference_number",length = 200)
    private String referenceNumber;

    public ResourceEntityAbstract(){
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }
}
