package com.bcxin.tenant.domain.entities;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Date;

@Data
public class EmployeeExportViewEntity extends EntityAbstract implements IAggregate {

    @Id
    @Column(length = 100)
    private String id;

    private String userId;

    //姓名
    @Column(name = "name")
    private String name;
    //手机号码
    @Column(name = "telephone")
    private String telephone;
    //证件类型
    @ExcelIgnore
    @Column(name = "credential_type")
    private CredentialType credentialType;
    //证件号码、
    @Column(name = "number")
    private String number;
    // 证件核验状态、
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "checked_status")
    private UserCheckedStatus checkedStatus;

    @Temporal(TemporalType.DATE)
    @Column(name="last_checked_status_time")
    private Date lastCheckedStatusTime;

    // 实名认证状态
    @Enumerated(EnumType.ORDINAL)
    @ExcelIgnore
    @Column(name = "authenticated_status")
    private RealNameAuthenticatedStatus authenticateStatus;
    //认证失败原因
    private String authenticatedResult;
    // 所属部门、
    @Column(name = "depart_name")
    private String departName;
    // 职位类型、
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "occupation_type")
    private OccupationType occupationType;
    // 上级、
    @Column(name = "superior_name")
    private String superiorName;
    // 职位、
    @Column(name = "position")
    private String position;
    // 入职时间、
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "hired_date")
    private Date hiredDate;
    // 转正日期、
    @Temporal(TemporalType.DATE)
    @Column(name = "positive_date")
    private Date positiveDate;
    // 性别、
    @Column(name = "sex")
    @Enumerated(EnumType.ORDINAL)
    private Sex sex;
    // 出生日期、
    @Temporal(TemporalType.DATE)
    @Column(name = "birthdate")
    private Date birthdate;
    // 民族、
    @Column(name = "nation")
    private String nation;
    // 文化程度、
    @Column(name = "education")
    private String education;
    // 政治面貌、
    @Column(name = "politics_status")
    private String politicsStatus;
    // 户籍类型、
    @Column(name = "household_type")
    private String householdType;
    // 身高、
    @Column(name = "stature")
    private String stature;
    // 籍贯、
    @Column(name = "native_place")
    private String nativePlace;
    // 兵役情况、
    @Column(name = "military_status")
    private String militaryStatus;
    // 婚姻状况、
    @Column(name = "marital_status")
    private String maritalStatus;
    // 身份证有效期、
    @Column(name = "valid_date_from")
    private Date validDateFrom;
    @Column(name = "valid_date_to")
    private Date validDateTo;
    // 身份证住址、
    @Column(name = "address")
    private String address;
    // 是否签订合同（至少有一条有效状态的合同信息）、
    @Column(name = "contract_status")
    private TrueFalseStatus contractStatus = TrueFalseStatus.False;
    private boolean contractStatusValue;
    // 是否有保安资格证（至少有一条保安员资格证信息）、
    @Column(name = "cer_status")
    private TrueFalseStatus cerStatus = TrueFalseStatus.False;
    private boolean cerStatusValue = false;
    // 是否有保安等级证（至少有一条保安员资格证信息）、
    @Column(name = "grade_cer_status")
    private TrueFalseStatus gradeCerStatus = TrueFalseStatus.False;
    private boolean gradeCerStatusValue = false;
    // 保安资格证号、
    @Column(name = "cer_no")
    private String cerNo;

    /**
     * 等级证等级
     */
    private String gradeLevel;
    /**
     * 等级证编号
     */
    private String gradeCerNo;

    // 是否投保（至少有一条生效的保单信息）、
    @Column(name = "insure")
    private TrueFalseStatus insure;
    // 录入系统时间（用户创建时间）、
    @Column(name = "created_time")
    private Date createdTime;
    // 是否为组织管理员、
    @Column(name = "is_domain_admin")
    private TrueFalseStatus domainAdmin;
    // 是否为部门管理员、
    @Column(name = "depart_admin")
    private TrueFalseStatus departAdmin = TrueFalseStatus.False;
    // 可管理部门
    @Column(name = "manage_departs")
    private String manageDeparts;

    @Column(name = "organ_id")
    private String organId;

    @Column(name = "person_status")
    private PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    @Column(name = "probation")
    private String probation;

    @Column(name = "plan_positive_date")
    @Temporal(TemporalType.DATE)
    private Date planPositiveDate;
    /**
     * 紧急联系人
     */
    @Column(name = "emergency_contact")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @Column(name = "emergency_phone")
    private String emergencyPhone;

    /**
     * 驾照等级
     */
    @Column(name = "license_level")
    private String licenseLevel;

    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name="province.code",
                    column=@Column(name="place_Of_now_province_code")),
            @AttributeOverride(name="province.name",
                    column=@Column(name="place_Of_now_province_name")),
            @AttributeOverride(name="city.code",
                    column=@Column(name="place_Of_now_city_code")),
            @AttributeOverride(name="city.name",
                    column=@Column(name="place_Of_now_city_name")),
            @AttributeOverride(name="district.code",
                    column=@Column(name="place_Of_now_district_code")),
            @AttributeOverride(name="district.name",
                    column=@Column(name="place_Of_now_district_name")),
            @AttributeOverride(name="address",
                    column=@Column(name="place_Of_now_address")),
    })
    private LocationValueType placeOfNow;

    /**
     * 入职操作人
     */
    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name = "id",
                    column = @Column(name = "hired_operator_id", nullable = true, length = 150)),
            @AttributeOverride(name = "name",
                    column = @Column(name = "hired_operator_name", nullable = true, length = 200)),
            @AttributeOverride(name = "createdTime",
                    column = @Column(name = "hired_operator_created_time", nullable = true))
    })
    private OperatorValueType hiredOperator;

    protected EmployeeExportViewEntity() {};

    public EmployeeExportViewEntity(
        String id,
        String userId,
        String name,
        String telephone,
       CredentialType credentialType,
       String number,
        UserCheckedStatus checkedStatus,
        Date lastCheckedStatusTime,
        RealNameAuthenticatedStatus authenticateStatus,
        String authenticatedResult,
        OccupationType occupationType,
        String superiorName,
        String position,
        Date hiredDate,
        Date positiveDate,
        Sex sex,
        Date birthdate,
        String nation,
        String education,
        String politicsStatus,
        String householdType,
        String stature,
        String nativePlace,
        String militaryStatus,
        String maritalStatus,
        Date validDateFrom,
        Date validDateTo,
        String address,
        boolean contractStatusValue,
//        boolean cerStatusValue,
//        boolean gradeCerStatusValue,
        TrueFalseStatus insure,
        Date createdTime,
        TrueFalseStatus domainAdmin,
        String organId,
        PersonStatus personStatus,
        String probation,
        Date planPositiveDate,
        String emergencyContact,
        String emergencyPhone,
        String licenseLevel,
        LocationValueType placeOfNow,
        OperatorValueType hiredOperator
    ) {
        this.id = id;
        this.userId = userId;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.number = number;
        this.checkedStatus = checkedStatus;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
        this.authenticateStatus = authenticateStatus;
        this.authenticatedResult = authenticatedResult;
        this.occupationType = occupationType;
        this.superiorName = superiorName;
        this.position = position;
        this.hiredDate = hiredDate;
        this.positiveDate = positiveDate;
        this.sex = sex;
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.stature = stature;
        this.nativePlace = nativePlace;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
        this.hiredOperator = hiredOperator;

        if(contractStatusValue){
            this.contractStatus = TrueFalseStatus.True;
        }
        if(cerStatusValue){
            this.cerStatus = TrueFalseStatus.True;
        }
        if(gradeCerStatusValue){
            this.gradeCerStatus = TrueFalseStatus.True;
        }
        this.insure = insure;
        this.createdTime = createdTime;
        this.domainAdmin = domainAdmin;
        this.organId = organId;
    }

    public void assignDepart(String name) {
        this.departName = name;
    }

    public void assignAdminDepart(String name) {
        this.manageDeparts = name;
        this.departAdmin = TrueFalseStatus.True;
    }

    public void setCerInfo(String cerNo){
        this.cerNo = cerNo;
        if(StrUtil.isNotEmpty(cerNo)){
            this.cerStatus = TrueFalseStatus.True;
            this.cerStatusValue = true;
        }
    }

    public void setGradeCerInfo(String gradeCerNo,String gradeLevel){
        this.gradeCerNo = gradeCerNo;
        this.gradeLevel = gradeLevel;
        if(StrUtil.isNotEmpty(gradeCerNo)){
            this.gradeCerStatus = TrueFalseStatus.True;
            this.gradeCerStatusValue = true;
        }
    }
}
