package com.bcxin.tenant.domain.dto;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Getter;

@Getter
public class EmployeeOccupationTypeValidationBasicDto {
    private final String tenantUserId;
    private final OccupationType occupationType;
    private final String organizationId;
    private final String organizationName;
    private final String areaCode;

    private final CredentialType credentialType;
    private final String credentialNumber;

    private final EmploymentStatus status;

    public EmployeeOccupationTypeValidationBasicDto(String tenantUserId,
                                                    CredentialType credentialType,
                                                    String credentialNumber,
                                                    OccupationType occupationType,
                                                    String organizationId, String organizationName,
                                                    String areaCode,
                                                    EmploymentStatus status) {
        this.tenantUserId = tenantUserId;
        this.occupationType = occupationType;
        this.organizationId = organizationId;
        this.areaCode = areaCode;
        this.organizationName = organizationName;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.status = status;
    }
}
