package com.bcxin.tenant.domain.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class AjaxResult implements Serializable {

	private static final long serialVersionUID = 4530474987109938356L;
	
	private boolean successful;
	private String code = "0";
	private String msg;
	private Object data;
	private Object obj;

	/**
	 * token 用做表单重复提交验证
	 */
	private String token;

	public AjaxResult(){

	}

	public AjaxResult(boolean successful, String code, String msg, Object data){
		this.successful = successful;
		this.code = code;
		this.msg = msg;
		this.data = data;
	}

	public static AjaxResult success(String msg, Object data){
		return new AjaxResult(true,"1",msg,data);
	}

	public static AjaxResult error(String msg, Object data){
		return new AjaxResult(false,"0",msg,data);
	}

	public static AjaxResult success(String msg){
		return new AjaxResult(true,"0",msg,null);
	}

	public static AjaxResult error(String msg){
		return new AjaxResult(false,"0",msg,null);
	}
}
