package com.bcxin.tenant.domain.configs;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@ConfigurationProperties(prefix = "register")
public class RegisterConfig {

    private static List<LegalConfig> legalConfigs;

    public static Map<String,LegalConfig> legalConfigMap = new HashMap<>();

    @Data
    public static class LegalConfig{
        private String areaCode;

        private String domainId;

        private String departId;

        private String roleId;
    }

    public static List<LegalConfig> getLegalConfigs() {
        return legalConfigs;
    }

    public void setLegalConfigs(List<LegalConfig> legalConfigs) {
        RegisterConfig.legalConfigs = legalConfigs;
        if (legalConfigs != null) {
            RegisterConfig.legalConfigMap = legalConfigs.stream().collect(Collectors.toMap(LegalConfig::getAreaCode, Function.identity()));
        }
    }
}
