package com.bcxin.tenant.domain.services.commands.xlcp;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;


@Getter
public class UpdateXlcpCommand extends CommandAbstract {

    private final String employeeId;
    private final String organizationId;
    private final String fileUrl;
    private final String suggestion;
    private final String content;
    private final Integer status;

    public UpdateXlcpCommand(String employeeId, String organizationId, String fileUrl, String suggestion, String content, Integer status) {
        this.employeeId = employeeId;
        this.organizationId = organizationId;
        this.fileUrl = fileUrl;
        this.suggestion=suggestion;
        this.content = content;
        this.status = status;
    }

    public static UpdateXlcpCommand create(String employeeId, String organizationId, String fileUrl, String suggestion, String content, Integer status) {
        return new UpdateXlcpCommand(employeeId, organizationId, fileUrl, suggestion, content, status);
    }

    @Override
    public void validate() {
        super.validate();

        if (!StringUtils.hasLength(this.getEmployeeId())) {
            throw new ArgumentTenantException("雇员不能为空");
        }

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("企业不能为空");
        }

        if (!StringUtils.hasLength(this.getFileUrl())) {
            throw new ArgumentTenantException("报告地址不能为空");
        }

        if (!StringUtils.hasLength(this.getSuggestion())) {
            throw new ArgumentTenantException("建议不能为空");
        }

        if (!StringUtils.hasLength(this.getContent())) {
            throw new ArgumentTenantException("评语不能为空");
        }

        if (this.getStatus() == null) {
            throw new ArgumentTenantException("状态设置不能为空");
        }
    }
}
