package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEventEntity;
import com.bcxin.tenant.domain.entities.UniqueDataConstraintEntity;
import com.bcxin.tenant.domain.events.EmployeeUpdatedEvent;
import com.bcxin.tenant.domain.repositories.EmployeeEventRepository;
import com.bcxin.tenant.domain.repositories.UniqueDataConstraintRepository;
import org.springframework.stereotype.Component;

@Component
public class EmployeeUpdatedEvent_EmployeeEventAndConstraintHandler extends DomainEventHandlerAbstract<EmployeeUpdatedEvent> {
    private final EmployeeEventRepository employeeEventRepository;
    private final UniqueDataConstraintRepository uniqueDataConstraintRepository;
    private final UnitWork unitWork;

    public EmployeeUpdatedEvent_EmployeeEventAndConstraintHandler(EmployeeEventRepository employeeEventRepository,
                                                                  UniqueDataConstraintRepository uniqueDataConstraintRepository,
                                                                  UnitWork unitWork) {
        this.employeeEventRepository = employeeEventRepository;
        this.uniqueDataConstraintRepository = uniqueDataConstraintRepository;
        this.unitWork = unitWork;
    }

    @Override
    protected void execute(EmployeeUpdatedEvent event) {
        this.unitWork.executeTran(() -> {
            this.employeeEventRepository.save(
                    EmployeeEventEntity.create(event.getData(), event.getEventType(),
                            event.getEventTime(), event.getNote()));
            /*
            离职和复职的的时候都无需去掉约束
            离职后只能通过走复职来实现再次入职
            String combinedId = UniqueDataConstraintEntity.getNewEmployeeCombinedId(event.getData().getTenantUser().getId());
            this.uniqueDataConstraintRepository.delete(combinedId);
             */
        });
    }
}
