package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.InvitedStatus;
import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

/**
 * 邀请入职部门
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_invited_to_join_queues")
@Entity
public class InvitedToJoinQueuesEntity extends EntityAbstract implements IAggregate {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;

    /**
     * 姓名
     */
    @Column(name = "name",nullable = false)
    private String name;

    /**
     * 手机号码
     */
    @Column(nullable = false, name = "telephone", length = 50)
    private String telephone;

    /**
     * 证件类型
     */
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "credential_type", nullable = false)
    private CredentialType credentialType;

    /**
     * 证件号码
     */
    @Column(name = "credential_number")
    private String credentialNumber;

    /**
     * 邀请人信息
     */
    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name="id",
                    column=@Column(name="inviter_id")),
            @AttributeOverride(name="name",
                    column=@Column(name="inviter_name")),
            @AttributeOverride(name="createdTime",
                    column=@Column(name="invitedTime"))
    })
    private OperatorValueType inviter;

    /**
     * 邀请类型
     */
    @Column(name = "invited_type")
    private InvitedType invitedType;

    /**
     * 邀请入职部门ID
     */
    @Column(name = "department_id")
    private String departmentId;

    /**
     * 邀请入职部门名称
     */
    @Column(name = "department_name")
    private String departmentName;

    /**
     * 邀请入职企业ID
     */
    @Column(name = "organization_id")
    private String organizationId;

    /**
     * 职业类型
     */
    @Column(name = "occupation_type")
    private OccupationType occupationType;

    /**
     * 邀请驻勤点名称
     */
    @Column(name = "attendancesite_name")
    private String attendanceSiteName;

    /**
     * 邀请驻勤点ID
     */
    @Column(name = "attendancesite_id")
    private String attendanceSiteId;

    /**
     * 邀请入职确认状态
     */
    @Column(name = "invited_status")
    private InvitedStatus invitedStatus;

    /**
     * 最后操作人Id(职员Id)
     */
    @Column(name = "last_operator_id")
    private String lastOperatorId;

    /**
     * 最后操作人姓名
     */
    @Column(name = "last_operator_name")
    private String lastOperatorName;

    /**
     * 最后操作时间
     */
    @Column(name = "last_operator_time")
    private Timestamp lastOperatorTime;

    public InvitedToJoinQueuesEntity(Long id, String name, String telephone, CredentialType credentialType,
                                     String credentialNumber, OperatorValueType inviter, InvitedType invitedType,
                                     String departmentId, String departmentName, String organizationId,
                                     OccupationType occupationType, String attendanceSiteName,
                                     String attendanceSiteId, InvitedStatus invitedStatus,
                                     String lastOperatorId, String lastOperatorName, Date lastOperatorTime) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.inviter = inviter;
        this.invitedType = invitedType;
        this.departmentId = departmentId;
        this.departmentName = departmentName;
        this.organizationId = organizationId;
        this.occupationType = occupationType;
        this.attendanceSiteName = attendanceSiteName;
        this.attendanceSiteId = attendanceSiteId;
        this.invitedStatus = invitedStatus;
        this.lastOperatorId = lastOperatorId;
        this.lastOperatorName = lastOperatorName;
        Timestamp ts = new Timestamp(lastOperatorTime.getTime());
        this.lastOperatorTime = ts;
    }

    public InvitedToJoinQueuesEntity(){

    }

    public static InvitedToJoinQueuesEntity create(String name,
                                                   String telephone,
                                                   CredentialType credentialType,
                                                   String credentialNumber,
                                                   OperatorValueType inviter,
                                                   InvitedType invitedType,
                                                   String departmentId,
                                                   String departmentName,
                                                   String organizationId,
                                                   OccupationType occupationType,
                                                   String attendanceSiteName,
                                                   String attendanceSiteId,
                                                   InvitedStatus invitedStatus,
                                                   String lastOperatorId,
                                                   String lastOperatorName) {
        InvitedToJoinQueuesEntity invitedToJoinQueuesEntity = new InvitedToJoinQueuesEntity();
        invitedToJoinQueuesEntity.setName(name);
        invitedToJoinQueuesEntity.setTelephone(telephone);
        invitedToJoinQueuesEntity.setCredentialType(credentialType);
        invitedToJoinQueuesEntity.setCredentialNumber(credentialNumber);
        invitedToJoinQueuesEntity.setInviter(inviter);
        invitedToJoinQueuesEntity.setInvitedType(invitedType);
        invitedToJoinQueuesEntity.setDepartmentId(departmentId);
        invitedToJoinQueuesEntity.setDepartmentName(departmentName);
        invitedToJoinQueuesEntity.setOrganizationId(organizationId);
        invitedToJoinQueuesEntity.setOccupationType(occupationType);
        invitedToJoinQueuesEntity.setAttendanceSiteName(attendanceSiteName);
        invitedToJoinQueuesEntity.setAttendanceSiteId(attendanceSiteId);
        invitedToJoinQueuesEntity.setInvitedStatus(invitedStatus);
        invitedToJoinQueuesEntity.setLastOperatorId(lastOperatorId);
        invitedToJoinQueuesEntity.setLastOperatorName(lastOperatorName);
        return invitedToJoinQueuesEntity;
    }

    public void change(InvitedStatus invitedStatus,String lastOperatorId,String lastOperatorName){
        this.setInvitedStatus(invitedStatus);
        this.setLastOperatorTime(Timestamp.from(Instant.now()));
        this.setLastOperatorId(lastOperatorId);
        this.setLastOperatorName(lastOperatorName);
    }
}
