package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.ValidStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_contracts")
@Entity
public class ContractEntity extends OpEntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "name", length = 1000)
    private String name;

    @ManyToOne
    @JoinColumn(name = "employee_id", referencedColumnName = "id", nullable = false,
            foreignKey =
            @ForeignKey(name = "fk_tenant_contract_employee_id", value = ConstraintMode.CONSTRAINT))
    private EmployeeEntity employee;

    @ManyToOne
    @JoinColumn(name = "organization_id", referencedColumnName = "id", nullable = false,
            foreignKey = @ForeignKey(name = "fk_tenant_contract_organization_id", value = ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;

    /**
     * 甲方
     */
    @Column(name = "a_name", length = 500)
    private String aName;
    /**
     * 乙方
     */
    @Column(name = "b_name", length = 500)
    private String bName;

    @Column(name = "begin_date", nullable = false)
    @Temporal(TemporalType.DATE)
    private Date beginDate;
    @Column(name = "end_date", nullable = true)
    @Temporal(TemporalType.DATE)
    private Date endDate;

    /**
     * 是否为无期徙合同
     */
    @Column(name = "date_limit_less", nullable = false)
    private TrueFalseStatus dateLimitless;

    /**
     * 电子合同文件
     */
    @Column(name = "attachment")
    private String attachment;

    /**
     * 备注
     */
    @Column(name = "note", length = 2000)
    private String note;

    /**
     * 是否有效
     * 当职员离职的时候，该合同就自动失效
     */
    @Column(name = "status", nullable = false)
    @Enumerated(EnumType.ORDINAL)
    private ValidStatus status;

    @Column(name = "status_note", length = 500)
    private String statusNote;

    public void change(String name, String aName, String bName, String note, Date beginDate, Date endDate, boolean dateLimitless) {
        this.setName(name);
        this.setAName(aName);
        this.setBName(bName);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setNote(note);
        this.setDateLimitless(dateLimitless ? TrueFalseStatus.True : TrueFalseStatus.False);
    }

    public void changeAttachment(String attachment) {
        this.setAttachment(attachment);
    }

    public void changeNote(String note) {
        this.setNote(note);
    }

    public void changeStatus(ValidStatus status, String statusNote) {
        this.setStatus(status);
        this.setStatusNote(statusNote);
    }


    protected ContractEntity() {

    }

    public static ContractEntity create(
            EmployeeEntity employee, String name, String aName, String bName,
            Date beginDate, Date endDate, boolean dateLimitless) {
        ContractEntity contract = new ContractEntity();
        contract.setId(UUIDUtil.getShortUuid());
        contract.setName(name);
        contract.setEmployee(employee);
        contract.setAName(aName);
        contract.setBName(bName);
        contract.setBeginDate(beginDate);
        contract.setEndDate(endDate);
        contract.setDateLimitless(dateLimitless ? TrueFalseStatus.True : TrueFalseStatus.False);
        contract.setStatus(ValidStatus.Valid);
        contract.setOrganization(employee.getOrganization());

        return contract;
    }
}
