package com.bcxin.tenant.domain.conditions.impls;
import com.bcxin.tenant.domain.conditions.EmployeeLeaveCondition;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.EmployeeConditionDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Component
public class EmployeeLeaveConditionImpl implements EmployeeLeaveCondition {
    private final boolean enableLeaveCondition;
    private final TenantDbReader tenantDbReader;

    public EmployeeLeaveConditionImpl(
            @Value("${tenant.view.leave.condition.enabled:false}")
                    boolean enableLeaveCondition,
            TenantDbReader tenantDbReader) {
        this.enableLeaveCondition = enableLeaveCondition;
        this.tenantDbReader = tenantDbReader;
    }

    @Override
    public boolean match(Collection<String> employeeIds) {
        if (!this.enableLeaveCondition) {
            return true;
        }

        return this.tenantDbReader.checkIfNotMatchLeaveCondition(employeeIds);
    }

    @Override
    public List<EmployeeConditionDto> matchLeaveCondition(Collection<String> employeeIds) {
        if (!this.enableLeaveCondition) {
            return Collections.EMPTY_LIST;
        }

        return this.tenantDbReader.matchLeaveCondition(employeeIds);
    }


    @Override
    public List<EmployeeConditionDto> matchForAttendSite(Collection<String> employeeIds) {
        if (!this.enableLeaveCondition) {
            return Collections.EMPTY_LIST;
        }
        return this.tenantDbReader.matchForAttendSite(employeeIds);
    }
}