/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.tenant.domain.entities.DepartmentAdminEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.DepartmentAdminRepository;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.services.DepartAdminService;
import com.bcxin.tenant.domain.services.commands.BatchCreateDepartAdminCommand;
import com.bcxin.tenant.domain.services.commands.BatchDeleteDepartAdminCommand;
import com.bcxin.tenant.domain.services.commands.UpdateDepartAdminCommand;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartAdminServiceImpl
implements DepartAdminService {
    private final DepartmentAdminRepository departmentAdminRepository;
    private final DepartmentRepository departmentRepository;
    private final EmployeeRepository employeeRepository;

    public DepartAdminServiceImpl(DepartmentAdminRepository departmentAdminRepository, DepartmentRepository departmentRepository, EmployeeRepository employeeRepository) {
        this.departmentAdminRepository = departmentAdminRepository;
        this.departmentRepository = departmentRepository;
        this.employeeRepository = employeeRepository;
    }

    @Override
    public void dispatch(BatchCreateDepartAdminCommand command) {
        command.validate();
        Collection<DepartmentEntity> departmentEntities = this.departmentRepository.getByIds(command.getOrganizationId(), command.getDepartIds());
        Collection notExistsDepartmentIds = command.getDepartIds().stream().filter(ii -> !departmentEntities.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsDepartmentIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u90e8\u95e8(%s)\u4fe1\u606f", notExistsDepartmentIds.stream().collect(Collectors.joining(","))));
        }
        Collection<EmployeeEntity> employeeEntities = this.employeeRepository.getByIds(command.getOrganizationId(), command.getEmployeeIds());
        Collection notExistsEmployeeIds = command.getEmployeeIds().stream().filter(ii -> !employeeEntities.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsDepartmentIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u804c\u5458(%s)\u4fe1\u606f", notExistsEmployeeIds.stream().collect(Collectors.joining(","))));
        }
        this.departmentAdminRepository.batchCreate(employeeEntities, departmentEntities);
    }

    @Override
    public void dispatch(UpdateDepartAdminCommand command) {
        command.validate();
        Collection<DepartmentEntity> departmentEntities = this.departmentRepository.getByIds(command.getOrganizationId(), command.getDepartIds());
        Collection notExistsDepartmentIds = command.getDepartIds().stream().filter(ii -> !departmentEntities.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsDepartmentIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u90e8\u95e8(%s)\u4fe1\u606f", notExistsDepartmentIds.stream().collect(Collectors.joining(","))));
        }
        Optional employeeEntity = this.employeeRepository.findById(command.getEmployeeId());
        if (!employeeEntity.isPresent()) {
            throw new ArgumentTenantException("\u804c\u5458\u4fe1\u606f\u65e0\u6548!");
        }
        this.departmentAdminRepository.update((EmployeeEntity)((Object)employeeEntity.get()), departmentEntities);
    }

    @Override
    public void dispatch(BatchDeleteDepartAdminCommand command) {
        command.validate();
        Collection<DepartmentAdminEntity> departmentAdminEntities = this.departmentAdminRepository.getByEmployeeIds(command.getOrganizationId(), command.getEmployeeIds());
        Collection notExistsDepartAdminIds = command.getEmployeeIds().stream().filter(ii -> !departmentAdminEntities.stream().anyMatch(ix -> ix.getEmployee().getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsDepartAdminIds)) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u90e8\u95e8\u7ba1\u7406\u5458(%s)\u4fe1\u606f", notExistsDepartAdminIds.stream().collect(Collectors.joining(","))));
        }
        this.departmentAdminRepository.batchDelete(command.getEmployeeIds());
    }
}

