package com.bcxin.backend.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 背筛用户表
 * author: linchunpeng
 * date:  2023-07-12 18:17
 */
@Data
@TableName("bg_screening_users")
public class BgScreeningUser {

    private static final long serialVersionUID = 1L;

    @TableId(value = "pkId")
    private Long pkId;

    //用户id
    @TableField(value = "user_id")
    private String userId;

    //背景筛查状态
    @TableField(value = "background_screening_status")
    private Integer backgroundScreeningStatus;

    //最后背景筛查时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "last_background_screening_time")
    private Date lastBackgroundScreeningTime;

    //姓名
    @TableField(value = "`name`")
    private String name;

    //身份证号
    @TableField(value = "idnum")
    private String idnum;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "created_time")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "last_modified_time")
    private Date lastModifiedTime;

    //是否启用
    @TableField(value = "enabled")
    private Boolean enabled;

    //最近一次背筛结果
    @TableField(value = "last_bg_screening_result")
    private String lastBgScreeningResult;

    //最近一次背筛结果状态（0正常 1在逃，2吸毒，3重点，4精神，位移计算）
    @TableField(value = "last_bg_screening_result_status")
    private Integer lastBgScreeningResultStatus;

}
