/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.util.ftp.DownloadResult;
import com.bcxin.signature.util.ftp.DownloadTask;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class FtpUtil {
    /*
     * WARNING - void declaration
     */
    public static synchronized List<DownloadResult> download(String ftpPath, String[] listFileName) {
        void var7_9;
        String cont = "";
        ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(FileModeConfig.threadPoolSize);
        ArrayList results = new ArrayList();
        String[] stringArray = listFileName;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String fileName = stringArray[var7_9];
            DownloadTask upload = new DownloadTask(null, null, ftpPath, fileName);
            Future submit = newFixedThreadPool.submit(upload);
            results.add(submit);
            ++var7_9;
        }
        ArrayList<DownloadResult> listResults = new ArrayList<DownloadResult>();
        for (Future future : results) {
            try {
                DownloadResult uploadResult = (DownloadResult)future.get(15L, TimeUnit.SECONDS);
                System.err.println("=======>    FTP download DownloadResult\uff1a" + StringUtils.isNotEmpty((CharSequence)uploadResult.getContent()) + "   <=======");
                listResults.add(uploadResult);
            }
            catch (Exception e) {
                if (StringUtils.isEmpty((CharSequence)cont) && e.getMessage().contains("SocketException: Broken pipe")) {
                    cont = e.getMessage();
                }
                System.err.println("=======>\u7ebf\u7a0b\u6c60\u4e0b\u8f7dftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
            }
        }
        newFixedThreadPool.shutdown();
        if (StringUtils.isNotEmpty((CharSequence)cont)) {
            listResults = null;
        }
        return listResults;
    }

    public static boolean uploadBase64(String ftpPath, String ftpFileName, String base64Content) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.uploadBase64(ftpPath, ftpFileName, base64Content);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0a\u4f20base64\u6587\u4ef6\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static boolean downloadFile(String path, String filename, File dstFile) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.download(path, filename, dstFile);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static String downloadAsBase64(String path, String filename) {
        String result = "";
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.downloadAsBase64(path, filename);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0b\u8f7d\u6587\u4ef6\u8f93\u51fabase64\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static List<String> filenames(String path, String keywork) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.fileNames(path, keywork);
        }
        catch (IOException e) {
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6587\u4ef6\u540d\uff1a" + e.getMessage() + "<=======");
            return new ArrayList<String>();
        }
    }

    public static boolean delFilename(String path, String filename) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.delectFile(path, filename);
        }
        catch (IOException e) {
            System.err.println("=======>\u5220\u9664\u6307\u5b9a\u4f4d\u7f6e\u4e0b\u5bf9\u5e94\u6587\u4ef6\u540d\u6587\u4ef6\uff1a" + e.getMessage() + "<=======");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String path, String ftpFileName) {
        FtpConnection ftp = new FtpConnection();
        try {
            String string = ftp.getFileContent(path, ftpFileName);
            return string;
        }
        catch (IOException e) {
            System.err.println("=======>\u83b7\u53d6ftp\u6307\u5b9a\u6587\u4ef6\u7684\u6587\u4ef6\u5185\u5bb9\uff1a" + e.getMessage() + "<=======");
        }
        finally {
            try {
                ftp.delectFile(path, ftpFileName);
                ftp.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

