package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Time;
import java.util.Collection;
import java.util.Date;

@Schema(name = "RollCallPlanDetailResponse",title = "RollCallPlanDetailResponse 点名轮换详细界面")
@Getter
public class RollCallPlanDetailResponse  extends ResponseAbstract {
    private final String id;
    private final String name;
    private final Date beginDate;
    private final Date endDate;
    private final Collection<RepetitiveRule> repetitiveRules;
    private final String superviseDepartId;
    private final String superviseDepartName;
    private final Collection<String> stationTypes;
    private final Collection<Time> timers;

    public RollCallPlanDetailResponse(Long id, String name, Date beginDate, Date endDate,
                                      Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                                      String superviseDepartName,
                                      Collection<String> stationTypes, Collection<Time> timers) {
        this.id = String.valueOf(id);
        this.name = name;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.repetitiveRules = repetitiveRules;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.stationTypes = stationTypes;
        this.timers = timers;
    }

    public static RollCallPlanDetailResponse create(Long id, String name, Date beginDate, Date endDate,
                                                    Collection<RepetitiveRule> repetitiveRules, String superviseDepartId,
                                                    String superviseDepartName,
                                                    Collection<String> stationTypes, Collection<Time> timers) {
        return new RollCallPlanDetailResponse(id, name, beginDate, endDate, repetitiveRules,
                superviseDepartId, superviseDepartName, stationTypes, timers);
    }
}
