package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import lombok.Data;

@Data
public class DispatchContentFollowRequest extends RequestAbstract {
    private ContentFollowType followType;
    private String contentFollowId;
    private boolean follow;

    public static DispatchContentFollowRequest create(ContentFollowType followType,String contentFollowId,boolean follow) {
        DispatchContentFollowRequest request = new DispatchContentFollowRequest();
        request.setContentFollowId(contentFollowId);
        request.setFollowType(followType);
        request.setFollow(follow);

        return request;
    }
}