package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.jdks.requests.SyncUpdateGeoRequest;
import com.bcxin.tenant.open.jdks.requests.UpdateGeoRequest;

import java.util.Collection;

/**
 * 对当前用户更新坐标以及签到信息
 */
public interface UserWriterRpcProvider {

    /**
     * 更新坐标信息
     *
     * @param request
     */
    void updateLonLat(UpdateGeoRequest request);

    /**
     * 签到/签退
     */
    void switchMarkSwitch(DutySignInType dutySignInType);

    /**
     * 实时更新坐标信息及产生电子围栏的功能预警
     * @param request
     */
    void batchUpdateLonLat(Collection<SyncUpdateGeoRequest> request);
}
