package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.requests.CompanyOverviewRequest;
import com.bcxin.tenant.open.jdks.requests.CompanySearchRequest;
import com.bcxin.tenant.open.jdks.requests.SearchNearByCompanyRequest;
import com.bcxin.tenant.open.jdks.responses.CompanyDetailResponse;
import com.bcxin.tenant.open.jdks.responses.CompanyAdvanceResponse;
import com.bcxin.tenant.open.jdks.responses.CompanySearchResponse;
import com.bcxin.tenant.open.jdks.responses.SearchNearByCompanyResponse;

import java.util.Collection;

/**
 * RPC: 读取公司信息
 */
public interface CompanyReaderRpcProvider {
    CompanyDetailResponse get(String id, boolean includeForExamSiteRoom);

    Collection<CompanySearchResponse> search(CompanySearchRequest request);

    EntityCollection<CompanyAdvanceResponse> search(CompanyOverviewRequest request);

    Collection<SearchNearByCompanyResponse> search(SearchNearByCompanyRequest request);
}
