package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Set;

@Schema(name = "CompanyDetailResponse",title = "CompanyDetailResponse 企业详情信息")
@Getter
public class CompanyDetailResponse extends ResponseAbstract {
    @Schema(name = "id", title = "企业id")
    private final String id;

    @Schema(name = "name", title = "企业名称")
    private final String name;

    @Schema(name = "legal", title = "法人姓名")
    private final String legal;

    @Schema(name = "legalContact", title = "法人联系方式")
    private final String legalContact;

    @Schema(name = "registerAddress", title = "注册地")
    private final String registerAddress;

    @Schema(name = "countOfActivityStation", title = "驻勤点数量")
    private final Long countOfActivityStation;

    @Schema(name = "countOfSecurityMan", title = "保安员人数")
    private final Long countOfSecurityMan;

    @Schema(name = "countOfMan", title = "企业人员数量(针对内保单位, 此值为甲方管理员数)")
    private final Long countOfMan;

    @Schema(name = "latitude", title = "企业所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "企业所在x轴坐标")
    private final Double longitude;

    @Schema(name = "organizationId", title = "企业对应的组织Id")
    private final String organizationId;
    @Schema(name = "institutional", title = "机构类型; 这个是对应于 organization-type.json")
    private final String institutional;

    @Schema(name = "institutionalName", title = "机构类型名称; 这个是对应于 organization-type.json")
    private final String institutionalName;

    @Schema(name = "superviseDepartName", title = "监管机构")
    private final String superviseDepartName;

    private final Set<String> followedDeviceNos;

    @Schema(name = "followed", title = "是否关注")
    private final boolean followed;

    @Schema(name = "lastSyncTime", title = "最后同步时间")
    private final Timestamp lastSyncTime;

    @Schema(name = "resourceTypes", title = "资源类型: Security=保安;Population=社会力量;Proprietor=内保单位的甲方管理员;ProprietorManaged=内保单位管理的保安人员")
    private final Set<String> resourceTypes;

    @Schema(name = "scopePermissions", title = "调试: 可被查询范围")
    private final Set<String> scopePermissions;

    @Schema(name = "countOfExamSiteRooms", title = "考场数量")
    private final Integer countOfExamSiteRooms;



    public CompanyDetailResponse(String id, String name, String legal,
                                 String legalContact, String registerAddress,
                                 Long countOfActivityStation, Long countOfSecurityMan,
                                 Double latitude, Double longitude,
                                 String institutional,
                                 String organizationId,
                                 Integer countOfExamSiteRooms,
                                 String superviseDepartName,
                                 Set<String> followedDeviceNos,
                                 boolean followed,
                                 Long countOfMan,
                                 Set<String> resourceTypes,
                                 Set<String> scopePermissions,
                                 Timestamp lastSyncTime) {
        this.id = id;
        this.name = name;
        this.legal = StringUtil.isEmpty(legal) ? "" : legal;
        this.legalContact = StringUtil.isEmpty(legalContact) ? "" : legalContact;
        this.registerAddress = StringUtil.isEmpty(registerAddress) ? "" : registerAddress;
        this.countOfActivityStation = countOfActivityStation;
        this.countOfSecurityMan = countOfSecurityMan;
        this.latitude = latitude;
        this.longitude = longitude;
        this.institutional = institutional;
        this.organizationId = organizationId;
        this.countOfExamSiteRooms = countOfExamSiteRooms;
        this.superviseDepartName = superviseDepartName;
        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.institutionalName = BusinessUtil.getInstitutionalName(institutional);
        this.lastSyncTime = lastSyncTime;
        this.countOfMan = countOfMan;
        this.resourceTypes = resourceTypes;
        this.scopePermissions = scopePermissions;
    }

    public static CompanyDetailResponse create(String id, String name, String legal,
                                               String legalContact, String registerAddress,
                                               Long countOfActivityStation, Long countOfSecurityMan,
                                               Double latitude, Double longitude,
                                               String institutional,
                                               String organizationId,
                                               Integer countOfExamSiteRooms,
                                               String superviseDepartName,
                                               Set<String> followedDeviceNos,
                                               boolean followed,
                                               Long countOfMan,
                                               Set<String> resourceTypes,
                                               Set<String> scopePermissions,
                                               Timestamp lastSyncTime) {
        return new CompanyDetailResponse(id, name, legal, legalContact,
                registerAddress, countOfActivityStation, countOfSecurityMan,
                latitude, longitude, institutional, organizationId,countOfExamSiteRooms,
                superviseDepartName, followedDeviceNos, followed, countOfMan, resourceTypes,
                scopePermissions, lastSyncTime);
    }
}
