package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "CompanyOverviewResponse",title = "CompanyOverviewResponse 业务管理中的企业搜索结果")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CompanyAdvanceResponse extends ResponseAbstract {
    @ExcelIgnore
    @Schema(name = "id",title = "企业id")
    private final String id;
    @ExcelProperty("公司名称")
    @Schema(name = "name",title = "企业名称")
    private final String name;
    @ExcelProperty("法人/负责人")
    @Schema(name = "legal", title = "法人姓名")
    private final String legal;
    @ExcelProperty("法人/负责人手机号")
    @Schema(name = "legalContact", title = "法人联系方式")
    private final String legalContact;
    @ExcelProperty("联动值余额")
    @Schema(name = "points", title = "联动值余额")
    private final Long points;
    @ExcelProperty("调度台数量")
    @Schema(name = "countOfDesk", title = "可用调度台数量")
    private final int countOfDesk;
    @ExcelProperty("是否设置经纬度坐标")
    @Schema(name = "hasLonLat", title = "是否设置经纬度坐标")
    private final boolean hasLonLat;
    @ExcelIgnore
    @Schema(name = "latitude", title = "latitude")
    private final String latitude;
    @ExcelIgnore
    @Schema(name = "longitude", title = "longitude")
    private final String longitude;
    @ExcelProperty("驻勤点数")
    @Schema(name = "countOfStation", title = "有效驻勤点数量")
    private long countOfStation;
    @ExcelProperty("驻勤人员数")
    @Schema(name = "countOfSecurityMan", title = "有效保安员数量")
    private long countOfSecurityMan;
    @ExcelIgnore
    @Schema(name = "countOfProject", title = "项目数")
    private long countOfProject;


    public CompanyAdvanceResponse(String id, String name, String legal,
                                  String legalContact, Long points,
                                  int countOfDesk,long countOfProject,
                                  Double latitude, Double longitude,
                                  boolean hasLonlat,
                                  boolean validLonlat) {
        this.id = id;
        this.name = name;
        this.legal = legal;
        this.legalContact = legalContact;
        this.points = points;
        this.countOfDesk = countOfDesk;

        this.hasLonLat = hasLonlat;
        this.longitude = validLonlat ? String.valueOf(longitude) : String.format("%s(无效)", longitude);
        this.latitude = validLonlat ? String.valueOf(latitude) : String.format("%s(无效)", latitude);
    }

    public void assignStationInfo(long countOfStation,long countOfSecurityMan)
    {
        this.countOfStation = countOfStation;
        this.countOfSecurityMan = countOfSecurityMan;
    }

    public static CompanyAdvanceResponse create(String id, String name, String legal,
                                                String legalContact, Long points,
                                                int countOfDesk,long countOfProject,
                                                Double latitude, Double longitude,
                                                boolean hasLonlat,boolean validLonlat) {
        return new CompanyAdvanceResponse(
                id, name, legal, legalContact, points, countOfDesk,countOfProject, latitude,
                longitude, hasLonlat,validLonlat);
    }
}
