package com.bcxin.tenant.open.jdks.requests;

import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class TencentQueueCallbackRequest extends RequestAbstract{
    private final String roomId;
    private final Map<String,Object> data;
    private final Collection<String> publicUrls;

    public TencentQueueCallbackRequest(String roomId,Map<String, Object> data, Collection<String> publicUrls) {
        this.data = data;
        this.roomId = roomId;
        this.publicUrls = publicUrls;
    }

    public static TencentQueueCallbackRequest create(String roomId,Map<String, Object> data, Collection<String> publicUrls) {
        return new TencentQueueCallbackRequest(roomId, data, publicUrls);
    }
}
