package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "SecurityStationReaderRequest",description = "SecurityStationReaderRequest 高级筛选条件")
@Data
public class SecurityStationReaderRequest extends SearchDeskRequestAbstract {
    @Schema(name = "searchModel", title = "Address:根据地址搜索驻勤点, 否则搜索名称")
    private SearchModel searchModel;

    /**
     * 驻勤点名称/驻勤地址
     */
    @Schema(name = "keyword", title = "搜索驻勤名称")
    private String keyword;

    @Schema(name = "organizationId", title = "企业Id")
    private String organizationId;

    @Schema(name = "projectId", title = "所属项目Id")
    private String projectId;

    /**
     * 驻勤类型
     */
    @Schema(name = "stationTypes", title = "驻勤类型搜索[多选]")
    private Collection<String> stationTypes;

    @Schema(name = "latitude", title = "当searchModel=Location 的时候有效; 周边搜索的x轴的坐标")
    private double latitude;
    @Schema(name = "longitude", title = "当searchModel=Location 的时候有效; 周边搜索的y轴的坐标")
    private double longitude;

    @Schema(name = "distance", title = "当searchModel=Location 的时候有效; 周边搜索的半径长度定义,单位为米")
    private double distance;

    @Schema(name = "superviseDepartIds", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;

    @Schema(name = "followed",title = "安保资源: 当searchModel=SecurityResource 的时候有效; 根据是否关注进行过滤(null=全部; false=未关注; true=关注)")
    private Boolean followed;

    @Schema(name = "resourceType", title = "资源类型: resourceType=null 则搜索全部;Security=保安;Population=社会力量;Proprietor=内保单位的甲方管理员;ProprietorManaged=内保单位管理的保安人员")
    private ResourceType resourceType;

    @Schema(name = "SearchMode", title = "驻勤点搜索方式")
    public enum SearchModel {
        @Schema(name = "Name", title = "根据名称搜索驻勤点")
        Name,
        //@Schema(name = "Address", title = "根据地址搜索驻勤点")
        //Address,
        @Schema(name = "Location", title = "根据坐标搜索周边驻勤点")
        Location,
        @Schema(name = "SecurityResource", title = "安保资源")
        SecurityResource,
        @Schema(name = "StationType", title = "驻勤点类型")
        StationType,

        @Schema(name = "DispatchBookAddress", title = "调度通讯录; 支持分页以及根据名称继续搜索")
        DispatchBookAddress,
        @Schema(name = "Company", title = "根据企业Id获取驻勤列表; 滚动分页的方式展示")
        Organization,

        //@Schema(name = "TemporarySecurity", title = "根据临保项目Id获取驻勤列表; 不分页")
        //TemporarySecurity
    }
}
