package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import lombok.Data;

import java.util.Collection;

@Data
public class RoomReplyRequest extends RequestAbstract{
    private Long id;
    private TRTCActionType actionType;
    private Collection<String> employeeIds;

    public static RoomReplyRequest create(Long id,TRTCActionType actionType,
                                          Collection<String> employeeIds) {
        RoomReplyRequest request = new RoomReplyRequest();
        request.setId(id);
        request.setActionType(actionType);
        request.setEmployeeIds(employeeIds);


        return request;
    }
}
