package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Time;
import java.util.Collection;
import java.util.Date;

@Schema(name = "RollCallPlanRequest",title = "点名计划的请求")
@Data
public class RollCallPlanRequest extends RequestAbstract {
    /**
     * 计划名称
     */
    @Schema(name = "name", title = "计划名称")
    private String name;
    /**
     * 开始时间范围
     */
    @Schema(name = "beginDate", title = "开始时间范围")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    /**
     * 结束时间范围
     */
    @Schema(name = "endDate", title = "结束时间范围")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    /**
     * 重复规则
     */
    @Schema(name = "repetitiveRules", title = "重复规则;多选")
    private Collection<RepetitiveRule> repetitiveRules;

    /**
     * 辖区Id
     */
    @Schema(name = "superviseDepartId", title = "辖区Id")
    private String superviseDepartId;

    /**
     * 辖区中文名
     */
    @Schema(name = "superviseDepartName", title = "辖区中文名")
    private String superviseDepartName;

    /**
     * 驻勤点类型; 多选
     */
    @Schema(name = "stationTypes", title = "驻勤点类型")
    private Collection<String> stationTypes;

    /**
     * 点名时间点;客户端需要验证时间间隔不能小于1小时
     */
    @Schema(name = "timers", title = "点名时间: 点名时间点;客户端需要验证时间间隔不能小于1小时")
    private Collection<Time> timers;
}
