package com.bcxin.tenant.open.jdks.requests;

import lombok.Data;

import java.util.Collection;

@Data
public class RollCallBatchDispatchRequest extends RequestAbstract {
    private Collection<RollCallDispatchRequest> items;

    public static RollCallBatchDispatchRequest create(Collection<RollCallDispatchRequest> items) {
        RollCallBatchDispatchRequest rq = new RollCallBatchDispatchRequest();
        rq.setItems(items);

        return rq;
    }

    @Data
    public static class RollCallDispatchRequest extends RequestAbstract
    {
        private Long rollCallId;
        private String roomId;
        private Collection<String> employeeIds;

        public static RollCallDispatchRequest create(Long rollCallId,String roomId,Collection<String> employeeIds) {
            RollCallDispatchRequest rq = new RollCallDispatchRequest();
            rq.setRollCallId(rollCallId);
            rq.setRoomId(roomId);
            rq.setEmployeeIds(employeeIds);

            return rq;
        }
    }
}
