package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "RdSecurityStationRailSearchRequest",title = "RdSecurityStationRailSearchRequest 搜索电子围栏")
@Data
public class RdSecurityStationRailSearchRequest extends SearchRequestAbstract {
    @Schema(name = "stationId",title = "驻勤点Id: 当searchModel=Station 的时候有效; 根据驻勤点Id过滤")
    private String stationId;

    @Schema(name = "superviseDepartId",title = "安保资源: 当searchModel=SecurityResource 的时候有效; 选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;

    @Schema(name = "keyWord", title = "关键字：当searchModel=Search 的时候有效; 根据搜索电子围栏名称过滤")
    private String keyWord;

    @Schema(name = "searchModel",title = "搜索模式: SecurityResource 则表示安保资源;Search 则表示搜索电子围栏名称;Station则表示按照驻勤点Id搜索;不可空")
    private SearchModel searchModel;

    public static enum SearchModel {
        SecurityResource,
        Search,
        Station
    }
}
