package com.bcxin.tenant.open.jdks.requests;

import lombok.Data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class PoliceIncidentStatisticsRequest extends RequestAbstract {
    private boolean fromRedis;

    private boolean fromSocketRequest;

    private Collection<String> superviseDepartIds;

    public PoliceIncidentStatisticsRequest(){}

    public static PoliceIncidentStatisticsRequest create(boolean fromRedis) {
        PoliceIncidentStatisticsRequest request = new PoliceIncidentStatisticsRequest();
        request.setFromRedis(fromRedis);

        return request;
    }

    public static PoliceIncidentStatisticsRequest create(boolean fromSocketRequest,String[] superviseDepartIds) {
        PoliceIncidentStatisticsRequest request = new PoliceIncidentStatisticsRequest();
        request.setFromRedis(false);
        request.setFromSocketRequest(fromSocketRequest);
        if (superviseDepartIds == null) {
            request.setSuperviseDepartIds(new ArrayList<>());
        } else {
            request.setSuperviseDepartIds(Arrays.stream(superviseDepartIds).toList());
        }

        return request;
    }
}
