package com.bcxin.tenant.open.jdks.requests;

import lombok.Data;

import java.util.Collection;

@Data
public class HotCacheRequest extends RequestAbstract{

    private CacheCategory category;
    private Collection<String> ids;

    public static enum CacheCategory {
        Employee,
        Organization,
        Station,
        OrgPurse,
        DispatchDataSource
    }

    public static HotCacheRequest create(CacheCategory category,Collection<String> ids) {
        HotCacheRequest rq = new HotCacheRequest();
        rq.setCategory(category);
        rq.setIds(ids);

        return rq;
    }
}
