package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.jdks.requests.enums.EmployeeResourceType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Optional;

@Schema(name = "EmployeeSearchRequest",title = "EmployeeSearchRequest 高级筛选条件")
@Data
public class EmployeeSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "keyword", title = "当searchModel=keyword 的时候有效; 搜索姓名/身份证信息;其中如果keyword如果只包含数字;则系统只搜索身份证")
    private String keyword;
    @Schema(name = "latitude", title = "当searchModel=geo 的时候有效; 周边搜索的x轴的坐标")
    private double latitude;
    @Schema(name = "longitude", title = "当searchModel=geo 的时候有效; 周边搜索的y轴的坐标")
    private double longitude;
    @Schema(name = "distance", title = "当searchModel=geo 的时候有效; 周边搜索的半径长度定义,单位为米")
    private double distance;
    @Schema(name = "searchModel", title = "搜索模式: keyword 则表示搜索姓名/身份证; geo 则表示进行周边搜索; Other 则表示按照驻勤类型进行搜索; DispatchBookAddress 调度通讯录-支持根据驻勤点Id和关键字进行搜索并分页")
    private SearchModel searchModel;
    @Schema(name = "stationTypes", title = "当searchModel=Other 的时候有效; 按照驻勤类型进行搜索; 当前是临保调度台的时候（适用于所有搜索模式）; 该值也将作为服务人员类型;（比如: 马拉松中的志愿者、医护人员、裁判等等）")
    private Collection<String> stationTypes;
    @Schema(name = "dispatchable", title = "当searchModel=Other 的时候有效; 按照可调度情况进行搜索")
    private Optional<Boolean> dispatchable;

    @Schema(name = "projectId", title = "所属项目Id")
    private String projectId;

    @Schema(name = "securityStationIds", title = "当searchModel=securityStation 的时候有效; 根据驻勤点Id滚动查询保安人员; 根据pageIndex和pageSize进行滚动")
    private Collection<String> securityStationIds;

    @Schema(name = "examSiteRoomId",title = "当searchModel=ExamSiteRoom 的时候有效; 根据考场Id滚动查询保安人员; 根据pageIndex和pageSize进行滚动")
    private String examSiteRoomId;

    @Schema(name = "skipPageLimit", title = "skipPageLimit 是否跳过分页选项")
    private boolean skipPageLimit;

    @Schema(name = "superviseDepartIds", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;

    @Schema(name = "followed", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 根据是否关注进行过滤(null=全部; false=未关注; true=关注)")
    private Boolean followed;

    @Schema(name = "resourceTypes", title = "资源类型(集合): resourceType=null 则搜索全部;Security=保安;Population=社会力量;Proprietor=内保单位的甲方管理员;ProprietorManaged=内保单位管理的保安人员;兼职社会力量=Security+Population;全职社会力量=ProfessionalPopulation")
    private Collection<EmployeeResourceType> resourceTypes;

    @Schema(name = "onDuty", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 根据是否在岗进行过滤(null=全部; false=离岗;true=在岗)")
    private Boolean onDuty;

    @Schema(name = "ids", title = "当searchModel=SelectedEmployees的时候有效; 根据选中的Ids返回信息; 用于派出所或者安保资源中的圈选调度;")
    private Collection<String> ids;

    @Schema(name = "responsibleOfStationIds", title = "用于搜索驻勤点的负责人信息; 此处传的是所负责的驻勤点信息")
    private Collection<String> responsibleOfStationIds;

    public static enum SearchModel {
        Keyword,
        Geo,
        Other,
        SecurityStation,

        @Schema(name = "SecurityResource", title = "安保资源")
        SecurityResource,

        @Schema(name = "DispatchBookAddress", title = "调度通讯录")
        DispatchBookAddress,
        @Schema(name = "SelectedEmployees", title = "返回选中用户的信息")
        SelectedEmployees,
        @Schema(name = "ExamSiteRoom", title = "考场信息")
        ExamSiteRoom
    }
}
