package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.Getter;

import java.util.Collection;

@Data
public class CreateRollCallRequest extends RequestAbstract {
    @Schema(name = "rollCallPlanId", title = "点名")
    private Long rollCallPlanId;
    @Schema(name = "timeValue", title = "对应于点名轮换的time信息")
    private String timeValue;

    @Schema(name = "superviseDepartIds", title = "辖区列表")
    private Collection<String> superviseDepartIds;
    @Schema(name = "securityStationIds", title = "驻勤点Ids")
    private Collection<String> securityStationIds;

    @Schema(name = "stationTypes", title = "驻勤点类型")
    private Collection<String> stationTypes;

    private DoActionOperatorInfo operator;

    public static CreateRollCallRequest create(
            Long rollCallPlanId,String timeValue,
            Collection<String> superviseDepartIds,
            Collection<String> securityStationIds,
            Collection<String> stationTypes,
            DoActionOperatorInfo operator
            ) {
        CreateRollCallRequest rcr = new CreateRollCallRequest();
        rcr.setRollCallPlanId(rollCallPlanId);
        rcr.setTimeValue(timeValue);
        rcr.setSecurityStationIds(securityStationIds);
        rcr.setSuperviseDepartIds(superviseDepartIds);
        rcr.setStationTypes(stationTypes);
        rcr.setOperator(operator);

        return rcr;
    }

    public static CreateRollCallRequest create(
            Collection<String> superviseDepartIds,
            Collection<String> securityStationIds,
            Collection<String> stationTypes,
            DoActionOperatorInfo operator
    ) {

        return create(null, null,
                superviseDepartIds, securityStationIds, stationTypes, operator
        );
    }

    @Getter
    public static class DoActionOperatorInfo extends RequestAbstract {
        private String actionOrgInstitutional;
        /**
         * 执行该点名的企业
         */
        private String actionOrganizationId;
        private String actionOrganizationName;
        /**
         * 执行该点名的人
         */
        private String actionEmployeeId;
        private String actionEmployeeName;

        public DoActionOperatorInfo(
                String actionOrganizationId,
                String actionOrgInstitutional,
                String actionOrganizationName,
                String actionEmployeeId,
                String actionEmployeeName
        ) {
            this.actionOrganizationId = actionOrganizationId;
            this.actionOrganizationName = actionOrganizationName;
            this.actionEmployeeId = actionEmployeeId;
            this.actionEmployeeName = actionEmployeeName;
            this.actionOrgInstitutional = actionOrgInstitutional;
        }

        public static DoActionOperatorInfo create(String actionOrganizationId,
                                                  String actionOrgInstitutional,
                                                  String actionOrganizationName,
                                                  String actionEmployeeId,
                                                  String actionEmployeeName) {
            return new DoActionOperatorInfo(actionOrganizationId,actionOrgInstitutional, actionOrganizationName, actionEmployeeId, actionEmployeeName);
        }
    }
}
