package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.jdks.requests.EmployeeTrackRequest;
import com.bcxin.tenant.open.jdks.requests.UpdateEmployeeLocationRequest;
import com.bcxin.tenant.open.jdks.requests.UpdateGeoEmployeeRequest;
import com.bcxin.tenant.open.jdks.responses.EmployeeTrackResponse;

import java.util.Collection;

public interface EmployeeWriterRpcProvider {

    int flush2Redis(Collection<String> ids, boolean clearRails);

    int flush2RedisByTenantUserIds(Collection<String> tenantUserIds);

    int flushStation2Redis(Collection<String> ids);

    void update(UpdateGeoEmployeeRequest request);

    void flush2DbRedis(String content);

    Collection<String> getStationIdsByEmployeeIds(Collection<String> employeeIds);

    Collection<EmployeeTrackResponse> getTrackLocations(EmployeeTrackRequest request);

    Collection<String> getCheckingEmployeeIds(int pageIndex, int pageSize);

    int clearNonUsedEmployees(int pageSize);

    int clearNonUsedEmployees(Collection<String> ids);

    void batchUpdateLocations(UpdateEmployeeLocationRequest request);
}
