/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CalculatePoliceIncidentsRequest
extends RequestAbstract {
    private final Collection<PoliceIncidentSnapshot> policeIncidents;

    public Map<String, Collection<PoliceIncidentSnapshot>> getPendingSuperviseDepartPoliceIncidentsMap() {
        if (this.getPoliceIncidents() == null || this.getPoliceIncidents().isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return this.executeKeyBySuperviseDepartId(this.getPoliceIncidents(), Stream.of(PoliceEventStatus.None).collect(Collectors.toList()));
    }

    public Map<String, Collection<PoliceIncidentSnapshot>> getUnPendingSuperviseDepartPoliceIncidentsMap() {
        if (this.getPoliceIncidents() == null || this.getPoliceIncidents().isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return this.executeKeyBySuperviseDepartId(this.getPoliceIncidents(), Arrays.stream(PoliceEventStatus.values()).filter(ix -> ix != PoliceEventStatus.None).collect(Collectors.toList()));
    }

    private Map<String, Collection<PoliceIncidentSnapshot>> executeKeyBySuperviseDepartId(Collection<PoliceIncidentSnapshot> input, Collection<PoliceEventStatus> statuses) {
        HashMap<String, Collection<PoliceIncidentSnapshot>> group = new HashMap<String, Collection<PoliceIncidentSnapshot>>();
        Collection pendings = input.stream().filter(ix -> statuses.contains(ix.getPoliceEventStatus())).collect(Collectors.toList());
        for (PoliceIncidentSnapshot snapshot : pendings) {
            if (StringUtil.isEmpty((String)snapshot.getSuperviseDepartId())) continue;
            ArrayList<PoliceIncidentSnapshot> snapshots = (ArrayList<PoliceIncidentSnapshot>)group.get(snapshot.getSuperviseDepartId());
            if (snapshots == null) {
                snapshots = new ArrayList<PoliceIncidentSnapshot>();
                group.put(snapshot.getSuperviseDepartId(), snapshots);
            }
            snapshots.add(snapshot);
        }
        return group;
    }

    public CalculatePoliceIncidentsRequest(Collection<PoliceIncidentSnapshot> policeIncidents) {
        this.policeIncidents = policeIncidents;
    }

    public static CalculatePoliceIncidentsRequest create(Collection<PoliceIncidentSnapshot> policeIncidents) {
        return new CalculatePoliceIncidentsRequest(policeIncidents);
    }

    public Collection<PoliceIncidentSnapshot> getPoliceIncidents() {
        return this.policeIncidents;
    }

    public static class PoliceIncidentSnapshot
    extends RequestAbstract {
        private Long id;
        @JSONField(name="tenant_user_id")
        private String tenantUserId;
        @JSONField(name="tenant_employee_id")
        private String tenantEmployeeId;
        @JSONField(name="organization_id")
        private String organizationId;
        @JSONField(name="security_station_id")
        private String securityStationId;
        @JSONField(name="supervise_depart_id")
        private String superviseDepartId;
        @JSONField(name="security_station_name")
        private String securityStationName;
        @JSONField(name="code")
        private String code;
        @JSONField(name="police_name")
        private String name;
        @JSONField(name="contact")
        private String contact;
        @JSONField(name="police_status")
        private PoliceEventStatus policeEventStatus;
        @JSONField(name="police_level")
        private PoliceEventLevel policeEventLevel;
        @JSONField(name="category")
        private PoliceEventCategory category;
        @JSONField(name="policeEventType")
        private int policeEventType;
        @JSONField(name="address")
        private String address;
        @JSONField(name="reason")
        private String reason;
        @JSONField(name="action_taken")
        private String actionTaken;
        @JSONField(name="action_tendency")
        private String actionTendency;
        @JSONField(name="processed_suggestion")
        private String processedSuggestion;
        @JSONField(name="processed_locale_guidance")
        private String processedLocaleGuidance;
        @JSONField(name="processed_user_id")
        private String processedUserId;
        @JSONField(name="processed_user_name")
        private String processedUserName;
        @JSONField(name="scene_url")
        private String sceneUrl;
        @JSONField(name="processed_time")
        private Timestamp processedTime;
        @JSONField(name="created_time")
        private Timestamp created_time;
        @JSONField(name="emp_name")
        private String empName;
        @JSONField(name="lon_lat")
        private LonlatLocationValue lonLat;
        public boolean isDeleted;

        public Long getId() {
            return this.id;
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public String getTenantEmployeeId() {
            return this.tenantEmployeeId;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public String getSecurityStationId() {
            return this.securityStationId;
        }

        public String getSuperviseDepartId() {
            return this.superviseDepartId;
        }

        public String getSecurityStationName() {
            return this.securityStationName;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String getContact() {
            return this.contact;
        }

        public PoliceEventStatus getPoliceEventStatus() {
            return this.policeEventStatus;
        }

        public PoliceEventLevel getPoliceEventLevel() {
            return this.policeEventLevel;
        }

        public PoliceEventCategory getCategory() {
            return this.category;
        }

        public int getPoliceEventType() {
            return this.policeEventType;
        }

        public String getAddress() {
            return this.address;
        }

        public String getReason() {
            return this.reason;
        }

        public String getActionTaken() {
            return this.actionTaken;
        }

        public String getActionTendency() {
            return this.actionTendency;
        }

        public String getProcessedSuggestion() {
            return this.processedSuggestion;
        }

        public String getProcessedLocaleGuidance() {
            return this.processedLocaleGuidance;
        }

        public String getProcessedUserId() {
            return this.processedUserId;
        }

        public String getProcessedUserName() {
            return this.processedUserName;
        }

        public String getSceneUrl() {
            return this.sceneUrl;
        }

        public Timestamp getProcessedTime() {
            return this.processedTime;
        }

        public Timestamp getCreated_time() {
            return this.created_time;
        }

        public String getEmpName() {
            return this.empName;
        }

        public LonlatLocationValue getLonLat() {
            return this.lonLat;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setTenantUserId(String tenantUserId) {
            this.tenantUserId = tenantUserId;
        }

        public void setTenantEmployeeId(String tenantEmployeeId) {
            this.tenantEmployeeId = tenantEmployeeId;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public void setSecurityStationId(String securityStationId) {
            this.securityStationId = securityStationId;
        }

        public void setSuperviseDepartId(String superviseDepartId) {
            this.superviseDepartId = superviseDepartId;
        }

        public void setSecurityStationName(String securityStationName) {
            this.securityStationName = securityStationName;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public void setPoliceEventStatus(PoliceEventStatus policeEventStatus) {
            this.policeEventStatus = policeEventStatus;
        }

        public void setPoliceEventLevel(PoliceEventLevel policeEventLevel) {
            this.policeEventLevel = policeEventLevel;
        }

        public void setCategory(PoliceEventCategory category) {
            this.category = category;
        }

        public void setPoliceEventType(int policeEventType) {
            this.policeEventType = policeEventType;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setActionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
        }

        public void setActionTendency(String actionTendency) {
            this.actionTendency = actionTendency;
        }

        public void setProcessedSuggestion(String processedSuggestion) {
            this.processedSuggestion = processedSuggestion;
        }

        public void setProcessedLocaleGuidance(String processedLocaleGuidance) {
            this.processedLocaleGuidance = processedLocaleGuidance;
        }

        public void setProcessedUserId(String processedUserId) {
            this.processedUserId = processedUserId;
        }

        public void setProcessedUserName(String processedUserName) {
            this.processedUserName = processedUserName;
        }

        public void setSceneUrl(String sceneUrl) {
            this.sceneUrl = sceneUrl;
        }

        public void setProcessedTime(Timestamp processedTime) {
            this.processedTime = processedTime;
        }

        public void setCreated_time(Timestamp created_time) {
            this.created_time = created_time;
        }

        public void setEmpName(String empName) {
            this.empName = empName;
        }

        public void setLonLat(LonlatLocationValue lonLat) {
            this.lonLat = lonLat;
        }

        public void setDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PoliceIncidentSnapshot)) {
                return false;
            }
            PoliceIncidentSnapshot other = (PoliceIncidentSnapshot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPoliceEventType() != other.getPoliceEventType()) {
                return false;
            }
            if (this.isDeleted() != other.isDeleted()) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$tenantUserId = this.getTenantUserId();
            String other$tenantUserId = other.getTenantUserId();
            if (this$tenantUserId == null ? other$tenantUserId != null : !this$tenantUserId.equals(other$tenantUserId)) {
                return false;
            }
            String this$tenantEmployeeId = this.getTenantEmployeeId();
            String other$tenantEmployeeId = other.getTenantEmployeeId();
            if (this$tenantEmployeeId == null ? other$tenantEmployeeId != null : !this$tenantEmployeeId.equals(other$tenantEmployeeId)) {
                return false;
            }
            String this$organizationId = this.getOrganizationId();
            String other$organizationId = other.getOrganizationId();
            if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
                return false;
            }
            String this$securityStationId = this.getSecurityStationId();
            String other$securityStationId = other.getSecurityStationId();
            if (this$securityStationId == null ? other$securityStationId != null : !this$securityStationId.equals(other$securityStationId)) {
                return false;
            }
            String this$superviseDepartId = this.getSuperviseDepartId();
            String other$superviseDepartId = other.getSuperviseDepartId();
            if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
                return false;
            }
            String this$securityStationName = this.getSecurityStationName();
            String other$securityStationName = other.getSecurityStationName();
            if (this$securityStationName == null ? other$securityStationName != null : !this$securityStationName.equals(other$securityStationName)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$contact = this.getContact();
            String other$contact = other.getContact();
            if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
                return false;
            }
            PoliceEventStatus this$policeEventStatus = this.getPoliceEventStatus();
            PoliceEventStatus other$policeEventStatus = other.getPoliceEventStatus();
            if (this$policeEventStatus == null ? other$policeEventStatus != null : !this$policeEventStatus.equals(other$policeEventStatus)) {
                return false;
            }
            PoliceEventLevel this$policeEventLevel = this.getPoliceEventLevel();
            PoliceEventLevel other$policeEventLevel = other.getPoliceEventLevel();
            if (this$policeEventLevel == null ? other$policeEventLevel != null : !this$policeEventLevel.equals(other$policeEventLevel)) {
                return false;
            }
            PoliceEventCategory this$category = this.getCategory();
            PoliceEventCategory other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$actionTaken = this.getActionTaken();
            String other$actionTaken = other.getActionTaken();
            if (this$actionTaken == null ? other$actionTaken != null : !this$actionTaken.equals(other$actionTaken)) {
                return false;
            }
            String this$actionTendency = this.getActionTendency();
            String other$actionTendency = other.getActionTendency();
            if (this$actionTendency == null ? other$actionTendency != null : !this$actionTendency.equals(other$actionTendency)) {
                return false;
            }
            String this$processedSuggestion = this.getProcessedSuggestion();
            String other$processedSuggestion = other.getProcessedSuggestion();
            if (this$processedSuggestion == null ? other$processedSuggestion != null : !this$processedSuggestion.equals(other$processedSuggestion)) {
                return false;
            }
            String this$processedLocaleGuidance = this.getProcessedLocaleGuidance();
            String other$processedLocaleGuidance = other.getProcessedLocaleGuidance();
            if (this$processedLocaleGuidance == null ? other$processedLocaleGuidance != null : !this$processedLocaleGuidance.equals(other$processedLocaleGuidance)) {
                return false;
            }
            String this$processedUserId = this.getProcessedUserId();
            String other$processedUserId = other.getProcessedUserId();
            if (this$processedUserId == null ? other$processedUserId != null : !this$processedUserId.equals(other$processedUserId)) {
                return false;
            }
            String this$processedUserName = this.getProcessedUserName();
            String other$processedUserName = other.getProcessedUserName();
            if (this$processedUserName == null ? other$processedUserName != null : !this$processedUserName.equals(other$processedUserName)) {
                return false;
            }
            String this$sceneUrl = this.getSceneUrl();
            String other$sceneUrl = other.getSceneUrl();
            if (this$sceneUrl == null ? other$sceneUrl != null : !this$sceneUrl.equals(other$sceneUrl)) {
                return false;
            }
            Timestamp this$processedTime = this.getProcessedTime();
            Timestamp other$processedTime = other.getProcessedTime();
            if (this$processedTime == null ? other$processedTime != null : !((Object)this$processedTime).equals(other$processedTime)) {
                return false;
            }
            Timestamp this$created_time = this.getCreated_time();
            Timestamp other$created_time = other.getCreated_time();
            if (this$created_time == null ? other$created_time != null : !((Object)this$created_time).equals(other$created_time)) {
                return false;
            }
            String this$empName = this.getEmpName();
            String other$empName = other.getEmpName();
            if (this$empName == null ? other$empName != null : !this$empName.equals(other$empName)) {
                return false;
            }
            LonlatLocationValue this$lonLat = this.getLonLat();
            LonlatLocationValue other$lonLat = other.getLonLat();
            return !(this$lonLat == null ? other$lonLat != null : !((Object)this$lonLat).equals(other$lonLat));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PoliceIncidentSnapshot;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPoliceEventType();
            result = result * 59 + (this.isDeleted() ? 79 : 97);
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $tenantUserId = this.getTenantUserId();
            result = result * 59 + ($tenantUserId == null ? 43 : $tenantUserId.hashCode());
            String $tenantEmployeeId = this.getTenantEmployeeId();
            result = result * 59 + ($tenantEmployeeId == null ? 43 : $tenantEmployeeId.hashCode());
            String $organizationId = this.getOrganizationId();
            result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
            String $securityStationId = this.getSecurityStationId();
            result = result * 59 + ($securityStationId == null ? 43 : $securityStationId.hashCode());
            String $superviseDepartId = this.getSuperviseDepartId();
            result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
            String $securityStationName = this.getSecurityStationName();
            result = result * 59 + ($securityStationName == null ? 43 : $securityStationName.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $contact = this.getContact();
            result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
            PoliceEventStatus $policeEventStatus = this.getPoliceEventStatus();
            result = result * 59 + ($policeEventStatus == null ? 43 : $policeEventStatus.hashCode());
            PoliceEventLevel $policeEventLevel = this.getPoliceEventLevel();
            result = result * 59 + ($policeEventLevel == null ? 43 : $policeEventLevel.hashCode());
            PoliceEventCategory $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $actionTaken = this.getActionTaken();
            result = result * 59 + ($actionTaken == null ? 43 : $actionTaken.hashCode());
            String $actionTendency = this.getActionTendency();
            result = result * 59 + ($actionTendency == null ? 43 : $actionTendency.hashCode());
            String $processedSuggestion = this.getProcessedSuggestion();
            result = result * 59 + ($processedSuggestion == null ? 43 : $processedSuggestion.hashCode());
            String $processedLocaleGuidance = this.getProcessedLocaleGuidance();
            result = result * 59 + ($processedLocaleGuidance == null ? 43 : $processedLocaleGuidance.hashCode());
            String $processedUserId = this.getProcessedUserId();
            result = result * 59 + ($processedUserId == null ? 43 : $processedUserId.hashCode());
            String $processedUserName = this.getProcessedUserName();
            result = result * 59 + ($processedUserName == null ? 43 : $processedUserName.hashCode());
            String $sceneUrl = this.getSceneUrl();
            result = result * 59 + ($sceneUrl == null ? 43 : $sceneUrl.hashCode());
            Timestamp $processedTime = this.getProcessedTime();
            result = result * 59 + ($processedTime == null ? 43 : ((Object)$processedTime).hashCode());
            Timestamp $created_time = this.getCreated_time();
            result = result * 59 + ($created_time == null ? 43 : ((Object)$created_time).hashCode());
            String $empName = this.getEmpName();
            result = result * 59 + ($empName == null ? 43 : $empName.hashCode());
            LonlatLocationValue $lonLat = this.getLonLat();
            result = result * 59 + ($lonLat == null ? 43 : ((Object)$lonLat).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "CalculatePoliceIncidentsRequest.PoliceIncidentSnapshot(id=" + this.getId() + ", tenantUserId=" + this.getTenantUserId() + ", tenantEmployeeId=" + this.getTenantEmployeeId() + ", organizationId=" + this.getOrganizationId() + ", securityStationId=" + this.getSecurityStationId() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", securityStationName=" + this.getSecurityStationName() + ", code=" + this.getCode() + ", name=" + this.getName() + ", contact=" + this.getContact() + ", policeEventStatus=" + this.getPoliceEventStatus() + ", policeEventLevel=" + this.getPoliceEventLevel() + ", category=" + this.getCategory() + ", policeEventType=" + this.getPoliceEventType() + ", address=" + this.getAddress() + ", reason=" + this.getReason() + ", actionTaken=" + this.getActionTaken() + ", actionTendency=" + this.getActionTendency() + ", processedSuggestion=" + this.getProcessedSuggestion() + ", processedLocaleGuidance=" + this.getProcessedLocaleGuidance() + ", processedUserId=" + this.getProcessedUserId() + ", processedUserName=" + this.getProcessedUserName() + ", sceneUrl=" + this.getSceneUrl() + ", processedTime=" + this.getProcessedTime() + ", created_time=" + this.getCreated_time() + ", empName=" + this.getEmpName() + ", lonLat=" + this.getLonLat() + ", isDeleted=" + this.isDeleted() + ")";
        }

        public static class LonlatLocationValue
        implements Serializable {
            private Double x;
            private Double y;

            public Double getLongitude() {
                return this.getY();
            }

            public Double getLatitude() {
                return this.getX();
            }

            public Double getX() {
                return this.x;
            }

            public Double getY() {
                return this.y;
            }

            public void setX(Double x) {
                this.x = x;
            }

            public void setY(Double y) {
                this.y = y;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LonlatLocationValue)) {
                    return false;
                }
                LonlatLocationValue other = (LonlatLocationValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Double this$x = this.getX();
                Double other$x = other.getX();
                if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                    return false;
                }
                Double this$y = this.getY();
                Double other$y = other.getY();
                return !(this$y == null ? other$y != null : !((Object)this$y).equals(other$y));
            }

            protected boolean canEqual(Object other) {
                return other instanceof LonlatLocationValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Double $x = this.getX();
                result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
                Double $y = this.getY();
                result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
                return result;
            }

            public String toString() {
                return "CalculatePoliceIncidentsRequest.PoliceIncidentSnapshot.LonlatLocationValue(x=" + this.getX() + ", y=" + this.getY() + ")";
            }
        }
    }
}

