/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Schema(name="ResourceType", title="\u4eba\u5458/\u9a7b\u52e4\u70b9\u7684\u8d44\u6e90\u7c7b\u578b")
public enum ResourceType {
    Security{

        @Override
        public String getTypeName() {
            return "\u4fdd\u5b89/\u9a7b\u52e4\u70b9";
        }

        @Override
        public int GetTypeValue() {
            return 1;
        }
    }
    ,
    Population{

        @Override
        public String getTypeName() {
            return "\u793e\u4f1a\u529b\u91cf/\u793e\u533a\u8b66\u52a1";
        }

        @Override
        public int GetTypeValue() {
            return 2;
        }
    }
    ,
    Proprietor{

        @Override
        public String getTypeName() {
            return "\u7532\u65b9\u7ba1\u7406\u5458";
        }

        @Override
        public int GetTypeValue() {
            return 4;
        }
    }
    ,
    ProprietorManaged{

        @Override
        public String getTypeName() {
            return "\u5185\u4fdd\u5355\u4f4d\u76f8\u5173\u7684\u4eba\u5458\u548c\u9a7b\u52e4\u70b9";
        }

        @Override
        public int GetTypeValue() {
            return 8;
        }
    }
    ,
    TemporarySecurity{

        @Override
        public String getTypeName() {
            return "\u4e34\u4fdd\u4e1a\u52a1";
        }

        @Override
        public int GetTypeValue() {
            return 16;
        }
    };


    public abstract String getTypeName();

    public abstract int GetTypeValue();

    public static String create(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return Security.name();
        }
        if ("0601".equalsIgnoreCase(institutional)) {
            return Population.name();
        }
        if (institutional.startsWith("04")) {
            return Proprietor.name();
        }
        return Security.name();
    }

    public static Set<String> getResources(Collection<DeskType> deskTypes) {
        if (deskTypes == null || deskTypes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set<String> resources = deskTypes.stream().flatMap(deskType -> {
            if (deskType == DeskType.Proprietor) {
                return Set.of(ProprietorManaged.name(), Proprietor.name()).stream();
            }
            if (deskType == DeskType.TemporarySecurity) {
                return Set.of(TemporarySecurity.name()).stream();
            }
            return Set.of(Security.name(), Population.name()).stream();
        }).collect(Collectors.toSet());
        return resources;
    }

    public static Set<ResourceType> toResourceTypes(Set<String> resourceTypes) {
        if (resourceTypes == null || resourceTypes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return resourceTypes.stream().filter(ii -> !StringUtil.isEmpty(ii)).map(ii -> {
            switch (ii) {
                case "Security": {
                    return Security;
                }
                case "Population": {
                    return Population;
                }
                case "Proprietor": {
                    return Proprietor;
                }
                case "ProprietorManaged": {
                    return ProprietorManaged;
                }
                case "TemporarySecurity": {
                    return TemporarySecurity;
                }
            }
            return null;
        }).filter(ii -> ii != null).collect(Collectors.toSet());
    }

    public static boolean hasResourceType(Set<String> resourceTypes, ResourceType resourceType) {
        if (resourceType == null) {
            return false;
        }
        Set<ResourceType> rts = ResourceType.toResourceTypes(resourceTypes);
        return rts.contains((Object)resourceType);
    }

    public static int getCalculatedResourceValue(Set<ResourceType> resourceTypes) {
        int calculatedValue = 0;
        if (resourceTypes == null) {
            return calculatedValue;
        }
        for (ResourceType rs : resourceTypes) {
            calculatedValue ^= rs.GetTypeValue();
        }
        return calculatedValue;
    }

    public static int getCalculatedResourceValueByDeskTypes(Collection<DeskType> deskTypes) {
        int calculatedValue = 0;
        if (deskTypes == null) {
            return calculatedValue;
        }
        for (DeskType dk : deskTypes.stream().collect(Collectors.toSet())) {
            switch (dk) {
                case Normal: {
                    calculatedValue ^= Security.GetTypeValue();
                    break;
                }
                case Proprietor: {
                    calculatedValue ^= Proprietor.GetTypeValue();
                    break;
                }
                case TemporarySecurity: {
                    calculatedValue ^= TemporarySecurity.GetTypeValue();
                }
            }
        }
        return calculatedValue;
    }
}

