/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;

public enum RollCallStatus {
    RollCallInit(1, "\u70b9\u540d\u521d\u59cb\u5316"),
    RollCallSuccess(2, "\u70b9\u540d\u6210\u529f"),
    RollCallFailed(4, "\u70b9\u540d\u5931\u8d25"),
    DispatchInit(8, "\u7763\u5bfc\u521d\u59cb\u5316"),
    DispatchSuccess(16, "\u7763\u5bfc\u6210\u529f"),
    DispatchFailed(32, "\u7763\u5bfc\u5931\u8d25");

    String name;
    int value;

    private RollCallStatus(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculate(Collection<RollCallStatus> callStatuses) {
        int result = 0;
        if (callStatuses != null && !callStatuses.isEmpty()) {
            for (RollCallStatus rule : callStatuses.stream().distinct().collect(Collectors.toList())) {
                result |= rule.value;
            }
        }
        return result;
    }

    public static Collection<RollCallStatus> getSelectedRollCallStatuses(int rollCallStatus) {
        HashSet<RollCallStatus> result = new HashSet<RollCallStatus>();
        for (RollCallStatus status : RollCallStatus.values()) {
            if ((status.value & rollCallStatus) <= 0) continue;
            result.add(status);
        }
        return result;
    }

    public static Collection<RollCallStatus> calculateRollCallStatus(Collection<RollCallStatus> currentStatuses, RollCallStatus newStatus) {
        if (currentStatuses == null) {
            currentStatuses = new ArrayList<RollCallStatus>();
        }
        currentStatuses = newStatus == DispatchFailed || newStatus == DispatchSuccess ? (Collection)currentStatuses.stream().filter(ii -> ii != DispatchSuccess && ii != DispatchFailed && ii != DispatchInit).collect(Collectors.toList()) : (Collection)currentStatuses.stream().filter(ii -> ii != RollCallSuccess && ii != RollCallFailed && ii != RollCallInit).collect(Collectors.toList());
        currentStatuses.add(newStatus);
        return currentStatuses;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

