package com.bcxin.tenant.open.dubbo.common.configs.filters;

import com.bcxin.tenant.open.dubbo.common.configs.DubboConstants;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.open.infrastructures.valueTypes.TrafficTagValueType;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;
import org.apache.dubbo.rpc.filter.TokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.stream.Collectors;

@Activate(group = {CommonConstants.PROVIDER,CommonConstants.CONSUMER})
public class AuthTokenFilter extends TokenFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);

    public AuthTokenFilter() {
        logger.error("GlobalExceptionFilter v2");
    }

    /**
     * 执行调用之前先绑定当前登入用户信息
     *
     * @param invoker
     * @param invocation
     * @return
     * @throws RpcException
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object data = invocation.getObjectAttachment(TenantEmployeeContext.CURRENT_TENANT_USER_INFO);
        if (data != null) {
            if (data instanceof TenantEmployeeContext.TenantUserModel userModel) {
                TenantContext.getInstance().getUserContext().init(userModel);
            } else {
                throw new NotSupportTenantException(String.format("异常数据类型发生异常:%s", data.getClass()));
            }
        }

        try {
            TrafficTagValueType trafficTagValueType = TenantContext.getInstance().resolve(TrafficTagValueType.class);
            RpcContext.getServerContext().setAttachment(TenantContext.PROVIDER_FLOW_TAG_NAME, trafficTagValueType);
        } catch (Exception ex) {
            //todo: 2024-12-23
        }

        return super.invoke(invoker, invocation);
    }
}
