package com.bcxin.tenant.open.backend.tasks.impls;

import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.jdks.QueueRpcProvider;
import com.bcxin.tenant.open.jdks.requests.CreateSosPoliceIncidentQueueRequest;
import com.bcxin.tenant.open.jdks.requests.SyncUpdateGeoRequest;
import com.bcxin.tenant.open.jdks.requests.TencentQueueCallbackRequest;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;


@DubboService
public class QueueRpcProviderImpl implements QueueRpcProvider {
    private static final Logger logger = LoggerFactory.getLogger(QueueRpcProviderImpl.class);

    private final KafkaTemplate kafkaTemplate;
    private final JsonProvider jsonProvider;

    public QueueRpcProviderImpl(KafkaTemplate kafkaTemplate, JsonProvider jsonProvider) {
        this.kafkaTemplate = kafkaTemplate;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void syncUpdatedLonLat(SyncUpdateGeoRequest request) {
        if (request == null) {
            throw new BadTenantException("无效数据");
        }

        try {
            if (!CollectionUtils.isEmpty(request.getEmployeeIds())) {
                String empId = request.getEmployeeIds().stream().findFirst().orElse(null);

                if (StringUtils.hasLength(empId)) {
                    int partition = Math.abs(empId.hashCode() % KafkaConstants.PARTITION_COUNT);

                    String data = this.jsonProvider.getJson(request);
                    this.kafkaTemplate.send(
                            KafkaConstants.TOPIC_EMPLOYEE_SYNC_LOCATION,
                            partition,
                            empId,
                            data
                    );
                }
            }
        }
        catch (Exception ex) {
            //todo
            logger.error("参数异常:{}", request, ex);
        }
    }

    @Override
    public void dispatch(CreateSosPoliceIncidentQueueRequest request) {
        int partition = Math.abs(String.valueOf(request.getTenantUserId()).hashCode() % KafkaConstants.PARTITION_COUNT);

        this.kafkaTemplate.send(
                KafkaConstants.TOPIC_NEW_POLICE_INCIDENT_REQUEST,
                partition,
                String.valueOf(request.getId()),
                this.jsonProvider.getJson(request)
        );
    }

    @Override
    public void dispatchTencentCallback(TencentQueueCallbackRequest request) {
        int partition = Math.abs(String.valueOf(request.getRoomId()).hashCode() % KafkaConstants.PARTITION_COUNT);

        this.kafkaTemplate.send(
                KafkaConstants.TOPIC_DISPATCH_TENCENT_CALLBACK,
                partition,
                String.valueOf(request.getRoomId()),
                this.jsonProvider.getJson(request)
        );
    }
}
