package com.bcxin.tenant.open.backend.tasks.dtos;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class ProprietorOrgWrapContent implements Serializable {
    private final Collection<ProprietorOrgContent> contents;

    public ProprietorOrgWrapContent(Collection<ProprietorOrgContent> contents) {
        this.contents = contents;
    }

    public static ProprietorOrgWrapContent create(Collection<ProprietorOrgContent> contents) {
        return new ProprietorOrgWrapContent(contents);
    }

    public static class ProprietorOrgContent implements Serializable {
        private final String id;
        private final String name;
        private final String superviseDepartId;
        private final String superviseDepartName;

        public ProprietorOrgContent(String id, String name, String superviseDepartId, String superviseDepartName) {
            this.id = id;
            this.name = name;
            this.superviseDepartId = superviseDepartId;
            this.superviseDepartName = superviseDepartName;
        }

        public static ProprietorOrgContent create(String id, String name, String superviseDepartId, String superviseDepartName) {
            return new ProprietorOrgContent(id, name, superviseDepartId, superviseDepartName);
        }
    }
}
