package com.bcxin.tenant.open.backend.tasks.configs;

import com.bcxin.tenant.open.backend.tasks.dtos.TimeCachedDataWrapper;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.open.jdks.RollCallPlanRpcProvider;
import com.bcxin.tenant.open.jdks.RollCallWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.CreateRollCallRequest;
import com.bcxin.tenant.open.jdks.requests.RollCallAutoCancelEmployeeRequest;
import com.bcxin.tenant.open.jdks.requests.ScheduledRollCallPlanSearchRequest;
import com.bcxin.tenant.open.jdks.responses.CreateRollCallResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallAutoCancelEmployeeResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanScheduledResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.*;
import java.util.stream.Collectors;

@Configuration
public class ScheduleConfig_RollCall implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfig_RollCall.class);
    private static TimeCachedDataWrapper<Collection<RollCallPlanScheduledResponse>> _timeCachedDataWrapper = null;
    private static Map<Long, Collection<Integer>> _processedHoursOfDayPlanMap = new HashMap<>();
    /**
     * 每60秒执行一次判断
     */
//    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void doAutoRollCall() {
        SimpleDateFormat hourDateFormat = new SimpleDateFormat("HHmm");
        Timestamp immediately = Timestamp.from(Instant.now());
        int hourOfNow = Integer.parseInt(hourDateFormat.format(immediately));

        Collection<Map.Entry<Long, Collection<Integer>>> passedHoursPlans =
                _processedHoursOfDayPlanMap.entrySet().stream()
                        .filter(ii -> ii.getValue().stream().anyMatch(ix -> ix < hourOfNow))
                        .collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(passedHoursPlans)) {
            StringBuilder rmLabel =new StringBuilder();
            passedHoursPlans.forEach(pi -> {

                rmLabel.append(String.format("点名计划Id=%s;已执行的时间点:%s;",pi.getKey(),pi.getValue().stream()
                        .map(ii->String.valueOf(ii.intValue())).collect(Collectors.joining(","))));
                _processedHoursOfDayPlanMap.remove(pi.getKey());
            });

            logger.error("清除(之后自动执行点名)如下已经点名的计划:{}",rmLabel);
        }

        Collection<RollCallPlanScheduledResponse> data = this.getScheduledRollCallPlans(hourOfNow);

        if (!CollectionUtils.isEmpty(data)) {
            RollCallWriterRpcProvider rollCallWriterRpcProvider = this.beanFactory.getBean(RollCallWriterRpcProvider.class);
            JsonProvider jsonProvider = this.beanFactory.getBean(JsonProvider.class);

            for (RollCallPlanScheduledResponse cpr : data) {
                Collection<Integer> hoursOfPlan = _processedHoursOfDayPlanMap.get(cpr.getId());
                if (hoursOfPlan == null) {
                    hoursOfPlan = new HashSet<>();
                }


                StringBuilder track = new StringBuilder();
                try {
                    Collection<Integer> matchedScheduledPlanTimes = cpr.getMatchedScheduledPlanTimes(hourOfNow, _processedHoursOfDayPlanMap);

                    track.append(
                            String.format("执行如下的计划:id=%s;repetitiveRule=%s;periodsOfTime=%s;superviseDepartId=%s;size=%s;",
                                    cpr.getId(), cpr.getStationTypes(), cpr.getRepetitiveRule(),
                                    cpr.getPeriodsOfTimes(),
                                    cpr.getSuperviseDepartId(),
                                    matchedScheduledPlanTimes.size()
                            ));

                    if (!CollectionUtils.isEmpty(matchedScheduledPlanTimes)) {
                        for (Integer selectedHourMinute : matchedScheduledPlanTimes) {
                            if (!hoursOfPlan.contains(selectedHourMinute)) {
                                track.append(String.format("执行执行如下的自动点名操作-%s-hourOfMinute=%s;",
                                        cpr.getId(), selectedHourMinute));
                                CreateRollCallRequest.DoActionOperatorInfo operator =
                                        CreateRollCallRequest.DoActionOperatorInfo.create(
                                                cpr.getActionOrganizationId(),
                                                cpr.getActionOrgInstitutional(),
                                                cpr.getActionOrganizationName(),
                                                cpr.getActionEmployeeId(),
                                                cpr.getActionEmployeeName()
                                        );

                                CreateRollCallRequest rq = CreateRollCallRequest.create(
                                        cpr.getId(),
                                        String.valueOf(selectedHourMinute),
                                        Collections.singleton(cpr.getSuperviseDepartId()),
                                        Collections.EMPTY_LIST,
                                        cpr.getStationTypes(), operator
                                );

                                try {
                                    CreateRollCallResponse rcResponse = rollCallWriterRpcProvider.create(rq);

                                    track.append(String.format("执行结果: rq=%s;rs={}", jsonProvider.getJson(rq), jsonProvider.getJson(rcResponse)));
                                    hoursOfPlan.add(selectedHourMinute);

                                    _processedHoursOfDayPlanMap.put(cpr.getId(), hoursOfPlan);
                                } catch (Exception ex) {
                                    track.append(String.format("执行结果: rq=%s;异常={}", jsonProvider.getJson(rq), ExceptionUtil.getStackMessage(ex)));
                                }
                            } else {
                                track.append(String.format("无需执行如下的重复点-%s-hourOfMinute=%s;", cpr.getId(), selectedHourMinute));
                            }
                        }
                    }
                } catch (Exception ex) {
                    track.append(String.format("异常:%s", ex.toString()));
                } finally {
                    logger.error("执行的点名结果:{}", track);
                }
            }

            if (CollectionUtils.isEmpty(data)) {
                logger.error("无任何点名计划");
            }
        } else {
            logger.error("获取到的点名计划的列表为:hourOfNow={}; 结果集为空", hourOfNow);
        }
    }

    @Scheduled(fixedDelay = 2 * 60 * 1000)
    public void doAutoCancelRollCallEmployees() {
        this.executeAutoCancelRollCall(RollCallStatus.RollCallInit);
    }

    @Scheduled(fixedDelay = 50 * 1000)
    public void doAutoCancelRollCallDispatchEmployees() {
        this.executeAutoCancelRollCall(RollCallStatus.DispatchInit);
    }

    private void executeAutoCancelRollCall(RollCallStatus callStatus) {
        RollCallWriterRpcProvider rollCallWriterRpcProvider
                = this.beanFactory.getBean(RollCallWriterRpcProvider.class);
        JsonProvider jsonProvider = this.beanFactory.getBean(JsonProvider.class);

        for (int index = 0; index < 50; index++) {
            RollCallAutoCancelEmployeeResponse response = null;
            try {
                response = rollCallWriterRpcProvider.dispatch(RollCallAutoCancelEmployeeRequest.create(callStatus));

                if (response.getAffectedCount() <= 0) {
                    break;
                }

                logger.error("v3.完成自动取消点名（督导）轮换:callStatus={}, index={};data={}", callStatus, index, jsonProvider.getJson(response));
            } catch (Exception ex) {
                logger.error("自动取消点名（督导）轮换发生异常:callStatus={}, index={};", callStatus, index, ex);
            }
        }
    }


    private Collection<RollCallPlanScheduledResponse> getScheduledRollCallPlans(int hourOfNow) {
        Collection<RollCallPlanScheduledResponse> pendingPlanScheduledResponse = null;
        if (_timeCachedDataWrapper == null || _timeCachedDataWrapper.isExpired()) {
            RollCallPlanRpcProvider rollCallPlanRpcProvider = this.beanFactory.getBean(RollCallPlanRpcProvider.class);

            Timestamp now = Timestamp.from(Instant.now());

            Collection<RollCallPlanScheduledResponse> data =
                    rollCallPlanRpcProvider.getScheduledRollCallPlans(
                            ScheduledRollCallPlanSearchRequest.create(now)
                    );

            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(now);

            nowCalendar.add(Calendar.MINUTE, 10);

            _timeCachedDataWrapper = TimeCachedDataWrapper.create(nowCalendar.getTime(), data);
        }

        pendingPlanScheduledResponse = _timeCachedDataWrapper.getData();

        if (CollectionUtils.isEmpty(pendingPlanScheduledResponse)) {
            return Collections.EMPTY_LIST;
        }

        Collection<RollCallPlanScheduledResponse> selectedRollCallPlanScheduledResponses = new HashSet<>();
        for (RollCallPlanScheduledResponse rps : pendingPlanScheduledResponse) {
            Collection<Integer> matchedScheduledPlanTimes = rps.getMatchedScheduledPlanTimes(hourOfNow, _processedHoursOfDayPlanMap);
            if (!CollectionUtils.isEmpty(matchedScheduledPlanTimes)) {
                selectedRollCallPlanScheduledResponses.add(rps);
            }
        }

        return selectedRollCallPlanScheduledResponses;
    }

    private BeanFactory beanFactory;
    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}
