package com.bcxin.tenant.open.backend.tasks.configs;

import com.bcxin.tenant.open.infrastructures.constants.KafkaConstants;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.TopicConfig;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.TopicBuilder;
import org.springframework.kafka.core.*;
import org.springframework.kafka.listener.*;

import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

/**
 * https://www.baeldung.com/spring-kafka
 */
@EnableKafka
@Configuration
public class KafkaConfig {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConfig.class);

    public KafkaConfig() {
    }

    @Value("${spring.kafka.bootstrap-servers}")
    private String bootstrapServer;

    @Value("${spring.kafka.consumer.enable-auto-commit}")
    private Boolean autoCommit;
    @Value("${spring.kafka.consumer.group-id}")private String groupId;

    @Value("${spring.kafka.consumer.auto-offset-reset}")
    private String autoOffsetReset;

    @Value("${spring.kafka.consumer.fetch-min-size}")
    private String fetchMinSize;

    @Value("${spring.kafka.consumer.fetch-max-wait}")
    private String fetchMaxWait;

    @Value("${spring.kafka.listener.ack-mode}")
    private ContainerProperties.AckMode ackMode;

    @Value("${spring.kafka.listener.concurrency}")
    private Integer concurrency;

    /**
     * 如果topic不存在, 那么则创建对应的主题
     * @return
     */
    @Bean
    public KafkaAdmin.NewTopics topics() {
        int partitionCount = 3;
        int replicaCount = 1;
        return new KafkaAdmin.NewTopics(
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_TENANT_EMPLOYEES)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_EXTERNAL_MEMBERS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_TENANT_USERS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_TENANT_ORGANIZATIONS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_COMPANYINFORMATION)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_STATION)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_STATION_PERSON)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PT_SECURITYMAN)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_TLK_DEVICE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_TLK_ORG_PURSE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_VGA_ROOMS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                /**
                 * 有限有效消息队列: 该队列只保留20分钟的数据
                 */
                TopicBuilder.name(KafkaConstants.TOPIC_EMPLOYEE_SYNC_LOCATION)
                        .config(TopicConfig.CLEANUP_POLICY_CONFIG, TopicConfig.CLEANUP_POLICY_DELETE)
                        .config(TopicConfig.RETENTION_MS_CONFIG, String.valueOf(1000 * 60 * 20))
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_NEW_POLICE_INCIDENT_REQUEST)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DEAD_LETTER_DISPATCH)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.HEADER_ORIGINAL_TOPIC_NAME)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_TENANT_EMPLOYEE_ATTENDANCE_RECORDS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_POLICE_INCIDENTS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_TMS_TLK_EXAM_ROOM)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_TMS_TLK_EXAM_SITE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_TMS_TLK_SYSTEM_EXAM_INFO)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ATTENDANCE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ROLL_CALL_RECORD)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ROLL_CALL_GE_TUI_LOG)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ROLL_CALL_GE_TUI_REQUEST)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_T_SUPERVISE_DEPARTMENT)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_N_SECURITY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_PROPRIETOR_COMPANY_CHANGED)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ROOM_EMPLOYEE_ACTION)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_ROLL_CALL_EMPLOYEE_ROOM)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_OBPM2_TENANT_DATA_PERMISSIONS)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_POST_PERSON)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_GROUP)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_DEVICE_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_TLK_HARDWARE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_TYPE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_JOIN)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_MANAGE_POST)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_SOURCE)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_POST)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_TEAM_POWER)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_TEAM)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_PROJECT)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),

                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_EMPLOYEE_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_EXAM_SITE_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_PROJECT_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_SECURITY_STATION_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_MANAGER)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_EVENT_POST_MANAGER)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_BAIBAODUNFLOW_TLK_ADD_WORK_DEMAND)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_TENCENT_CALLBACK)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build(),
                TopicBuilder.name(KafkaConstants.TOPIC_DISPATCH_RD_SECURITY_STATION_RAIL_SUMMARY)
                        .partitions(partitionCount)
                        .replicas(replicaCount)
                        .build()
        );
    }


    @Bean
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, String>> kafkaListenerContainerFactory(
            CommonErrorHandler commonErrorHandler) {
        ConcurrentKafkaListenerContainerFactory<String, String> factory =
                new ConcurrentKafkaListenerContainerFactory<>();
        factory.setConsumerFactory(consumerFactory());
        ContainerProperties containerProperties =
                factory.getContainerProperties();
        containerProperties.setPollTimeout(36_000);
        containerProperties.setAckMode(ackMode);
        factory.setBatchListener(true);
        factory.setAutoStartup(true);
        if(this.concurrency!=null) {
            factory.setConcurrency(this.concurrency.intValue());
        }

        factory.setCommonErrorHandler(commonErrorHandler);
        factory.setMissingTopicsFatal(true);

        return factory;
    }

    @Bean
    public ConsumerFactory<String, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory<>(consumerConfigs());
    }

    @Bean
    public Map<String, Object> consumerConfigs() {
        Map<String, Object> props = new HashMap<>();

        props.put(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG, bootstrapServer);
        props.put(ConsumerConfig.ENABLE_AUTO_COMMIT_CONFIG, autoCommit);
        props.put(ConsumerConfig.GROUP_ID_CONFIG, groupId);
        props.put(ConsumerConfig.KEY_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class);
        props.put(ConsumerConfig.VALUE_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class);
        props.put(ConsumerConfig.AUTO_OFFSET_RESET_CONFIG, autoOffsetReset);
        props.put(ConsumerConfig.FETCH_MIN_BYTES_CONFIG, this.fetchMinSize);
        props.put(ConsumerConfig.FETCH_MAX_WAIT_MS_CONFIG, this.fetchMaxWait);

        /**
         * https://www.coder.work/article/7748413
         */
        props.put(ConsumerConfig.REQUEST_TIMEOUT_MS_CONFIG, "60000");
        props.put(ConsumerConfig.FETCH_MAX_WAIT_MS_CONFIG, 3000);

        return props;
    }

    @Bean
    public CommonErrorHandler commonErrorHandler(KafkaTemplate kafkaTemplate) {
        final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition>
                destinationResolver = (cr, e) -> new TopicPartition(KafkaConstants.TOPIC_DEAD_LETTER_DISPATCH, cr.partition());

        BiFunction<ConsumerRecord<?, ?>, Exception, Headers> DEFAULT_HEADERS_FUNCTION =
                (rec, ex) -> {
                    Headers topicNameHeader = new RecordHeaders();
                    topicNameHeader.add(KafkaConstants.HEADER_ORIGINAL_TOPIC_NAME, rec.topic().getBytes());

                    return topicNameHeader;
                };
        DeadLetterPublishingRecoverer deadLetterPublishingRecoverer = new DeadLetterPublishingRecoverer(kafkaTemplate, destinationResolver) {
            @Override
            public void accept(ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, Exception exception) {
                boolean disallowedOrException = true;
                try {
                    if (!KafkaConstants.TOPIC_DEAD_LETTER_DISPATCH.equalsIgnoreCase(record.topic())) {
                        super.accept(record, consumer, exception);
                        disallowedOrException = false;
                    }
                } catch (Exception ex) {
                    disallowedOrException = true;
                }

                if (disallowedOrException) {
                    logger.error(String.format("send data to dead letter queue while error:topic=%s;key=%s;", record.topic(), record.key()));
                }
            }
        };

        deadLetterPublishingRecoverer.addHeadersFunction(DEFAULT_HEADERS_FUNCTION);
        return new DefaultErrorHandler(deadLetterPublishingRecoverer);
    }

    @Bean
    public CloseableHttpClient httpClient(){
        return HttpClientBuilder.create().build();
    }
}
