/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public class EntityCollection<T>
implements Serializable {
    private Collection<T> data;
    private Long totalCount;
    private int pageSize;

    public static <T> EntityCollection<T> create(Collection<T> data, int pageSize, Long totalCount) {
        EntityCollection<T> ec = new EntityCollection<T>();
        ec.setData(data);
        ec.setTotalCount(totalCount);
        ec.setPageSize(pageSize);
        return ec;
    }

    public static <T> EntityCollection<T> createForNoTotalCount(Collection<T> data, int pageSize) {
        EntityCollection<T> ec = new EntityCollection<T>();
        ec.setData(data);
        ec.setPageSize(pageSize);
        return ec;
    }

    public int getPageCount() {
        if (this.getPageSize() == 0) {
            return 0;
        }
        int pageCount = (int)Math.ceil((double)this.getTotalCount().longValue() * 1.0 / (double)this.getPageSize());
        return pageCount;
    }

    public static EntityCollection EMPTY() {
        return EntityCollection.create(Collections.EMPTY_LIST, 0, 0L);
    }

    public boolean endOfData() {
        return this.getData().size() < this.getPageSize();
    }

    public Collection<T> getData() {
        return this.data;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityCollection)) {
            return false;
        }
        EntityCollection other = (EntityCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        Collection<T> this$data = this.getData();
        Collection<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        Collection<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "EntityCollection(data=" + this.getData() + ", totalCount=" + this.getTotalCount() + ", pageSize=" + this.getPageSize() + ")";
    }
}

