/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdProjectDocument;
import com.bcxin.tenant.open.document.domains.documents.RdProjectDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RdCompanyDocumentRepository;
import com.bcxin.tenant.open.document.domains.utils.GeoPointUtils;
import com.bcxin.tenant.open.domains.entities.RdCompanyEntity;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RdCompanyEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(RdCompanyEntityUtils.class);

    public static RdCompanyDocument toDocument(RdCompanyEntity ii, RdCompanyDocumentRepository companyDocumentRepository, RdCompositedReader compositedReader, EntityStream entityStream) {
        RdCompanyDocument document = null;
        Optional companyDocumentOptional = companyDocumentRepository.findById((Object)ii.getId());
        if (companyDocumentOptional.isPresent()) {
            document = (RdCompanyDocument)companyDocumentOptional.get();
        } else {
            document = new RdCompanyDocument();
            document.setId(ii.getId());
            document.setOrganizationId(ii.getOrganizationId());
        }
        document.rest();
        if (BusinessUtil.checkIfDynamicCountOfStationsAndMen((String)ii.getInstitutional())) {
            Collection countOfSecurityMens;
            document.setCountOfActivityStation(Long.valueOf(0L));
            document.setCountOfSecurityMan(Long.valueOf(0L));
            String[] securityStationIds = (String[])((Set)entityStream.of(RdDispatchDataScopeDocument.class).filter((SearchFieldPredicate)RdDispatchDataScopeDocument$.SCOPES.in(new String[]{ii.getId()})).map(RdDispatchDataScopeDocument::getId).collect(Collectors.toSet())).toArray(String[]::new);
            if (securityStationIds != null && securityStationIds.length > 0 && !CollectionUtils.isEmpty((Collection)(countOfSecurityMens = (Collection)entityStream.of(RdSecurityStationDocument.class).filter((SearchFieldPredicate)RdSecurityStationDocument$.ID.in(securityStationIds)).map((Function)RdSecurityStationDocument$.COUNT_OF_SECURITY_MAN).collect(Collectors.toList())))) {
                document.setCountOfActivityStation(Long.valueOf(countOfSecurityMens.size()));
                document.setCountOfSecurityMan(Long.valueOf(countOfSecurityMens.stream().mapToInt(ix -> ix).sum()));
            }
        } else {
            document.setCountOfActivityStation(Long.valueOf(ii.getCountOfActivityStation()));
            document.setCountOfSecurityMan(Long.valueOf(ii.getCountOfSecurityMan()));
        }
        document.setStatus(ii.getStatus());
        document.setSuperviseRegionCode(ii.getSuperviseRegionCode());
        document.setName(ii.getName());
        document.setPoints(ii.getPoints());
        document.setCountOfDesk(ii.getCountOfDesk());
        document.setInstitutional(ii.getInstitutional());
        document.setLegal(ii.getLegal());
        document.setLegalTelephone(ii.getLegalTelephone());
        document.setOrganizationId(ii.getOrganizationId());
        document.setRegisterAddress(ii.getRegisterAddress());
        document.setBusinessAddress(ii.getBusinessAddress());
        document.setLastUpdatedTime(ii.getLastUpdatedTime());
        document.setServiceScope(ii.getServiceScope());
        document.addResourceTypes(new String[]{ResourceType.create((String)ii.getInstitutional())});
        document.setLonLat(GeoPointUtils.translate((String)ii.getLonLat()));
        if (document.getLonLat() != null && GeoLocationValueType.isValidLocation((Double)document.getLonLat().getY(), (Double)document.getLonLat().getX())) {
            document.setHasLonLatFlag(1);
        } else {
            document.setHasLonLatFlag(0);
        }
        document.setSuperviseDepartId(ii.getSuperviseDepartId());
        document.addScopePermissions(new String[]{ii.getSuperviseDepartId()});
        document.addScopePermissions(new String[]{ii.getId()});
        document.setSuperviseDepartName(ii.getSuperviseDepartName());
        document.setLastUpdatedTime(ii.getLastSyncTime());
        document.setIndustry(ii.getIndustry());
        document.setCountOfMan(Long.valueOf(ii.getCountOfMen()));
        document.updateWord(new String[]{document.getName()});
        long countOfProject = 0L;
        try {
            String[] organizationIds = new String[]{document.getOrganizationId()};
            countOfProject = entityStream.of(RdProjectDocument.class).filter((SearchFieldPredicate)RdProjectDocument$.SCOPE_PERMISSIONS.in(organizationIds)).count();
            document.updateCountOfProject(countOfProject);
        }
        catch (Exception ex) {
            logger.error("\u4e34\u4fdd\u9879\u76ee\u7edf\u8ba1\u53d1\u751f\u5f02\u5e38:{};name={};", new Object[]{document.getId(), document.getName(), ex});
        }
        return document;
    }
}

