/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.NotifyMessageDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument;
import com.bcxin.tenant.open.document.domains.documents.messages.MessageContentDocumentAbstract;
import com.bcxin.tenant.open.document.domains.documents.messages.RollCallMessageContentDocument;
import com.bcxin.tenant.open.document.domains.repositories.InstantActivityDataDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.NotifyMessageDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RollCallProgressStatusDocumentRepository;
import com.bcxin.tenant.open.document.domains.utils.DocumentScopeFilterUtils;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeHistoryEntity;
import com.bcxin.tenant.open.domains.entities.RollCallEntity;
import com.bcxin.tenant.open.domains.entities.TenantUserView;
import com.bcxin.tenant.open.domains.events.BatchDispatchRollCallEmployeeEvent;
import com.bcxin.tenant.open.domains.events.ReplyRollCallEmployeeStatusEvent;
import com.bcxin.tenant.open.domains.exceptions.GeTuiBadTenantException;
import com.bcxin.tenant.open.domains.pojo.OrganizationPoJo;
import com.bcxin.tenant.open.domains.pojo.RollCallRulePoJo;
import com.bcxin.tenant.open.domains.pojo.SecurityDepartPoJo;
import com.bcxin.tenant.open.domains.pojo.SecurityStationPoJo;
import com.bcxin.tenant.open.domains.repositories.RollCallEmployeeHistoryRepository;
import com.bcxin.tenant.open.domains.repositories.RollCallEmployeeRepository;
import com.bcxin.tenant.open.domains.repositories.RollCallRepository;
import com.bcxin.tenant.open.domains.repositories.TenantUserViewRepository;
import com.bcxin.tenant.open.domains.services.RollCallService;
import com.bcxin.tenant.open.domains.services.commands.BatchRollCallEmployeeCommand;
import com.bcxin.tenant.open.domains.services.commands.CancelRollCallEmployeeCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateRollCallCommand;
import com.bcxin.tenant.open.domains.services.commands.ReplyRollCallEmployeeStatusCommand;
import com.bcxin.tenant.open.domains.services.commands.RollCallBatchDispatchCommand;
import com.bcxin.tenant.open.domains.services.commands.RollCallBatchEmployeeRoomActionCommand;
import com.bcxin.tenant.open.domains.services.commands.results.CancelRollCallEmployeeCommandResult;
import com.bcxin.tenant.open.domains.services.commands.results.CreateRollCallCommandResult;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.NotifyMessageType;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.bcxin.tenant.open.infrastructures.events.DomainEvent;
import com.bcxin.tenant.open.infrastructures.events.EventDispatcher;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RollCallServiceImpl
implements RollCallService {
    private static final Logger logger = LoggerFactory.getLogger(RollCallServiceImpl.class);
    private final UnitWork unitWork;
    private final RollCallRepository rollCallRepository;
    private final RollCallEmployeeRepository rollCallEmployeeRepository;
    private final RollCallEmployeeHistoryRepository rollCallEmployeeHistoryRepository;
    private final KafkaTemplate kafkaTemplate;
    private final JsonProvider jsonProvider;
    private final EntityStream entityStream;
    private final IdWorker idWorker;
    private final EventDispatcher eventDispatcher;
    private final TenantUserViewRepository tenantUserViewRepository;
    private final NotifyMessageDocumentRepository notifyMessageDocumentRepository;
    private final InstantActivityDataDocumentRepository instantActivityDataDocumentRepository;
    private final RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository;

    public RollCallServiceImpl(UnitWork unitWork, RollCallRepository rollCallRepository, RollCallEmployeeRepository rollCallEmployeeRepository, RollCallEmployeeHistoryRepository rollCallEmployeeHistoryRepository, KafkaTemplate kafkaTemplate, JsonProvider jsonProvider, EntityStream entityStream, IdWorker idWorker, EventDispatcher eventDispatcher, TenantUserViewRepository tenantUserViewRepository, NotifyMessageDocumentRepository notifyMessageDocumentRepository, InstantActivityDataDocumentRepository instantActivityDataDocumentRepository, RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository) {
        this.unitWork = unitWork;
        this.rollCallRepository = rollCallRepository;
        this.rollCallEmployeeRepository = rollCallEmployeeRepository;
        this.rollCallEmployeeHistoryRepository = rollCallEmployeeHistoryRepository;
        this.kafkaTemplate = kafkaTemplate;
        this.jsonProvider = jsonProvider;
        this.entityStream = entityStream;
        this.idWorker = idWorker;
        this.eventDispatcher = eventDispatcher;
        this.tenantUserViewRepository = tenantUserViewRepository;
        this.notifyMessageDocumentRepository = notifyMessageDocumentRepository;
        this.instantActivityDataDocumentRepository = instantActivityDataDocumentRepository;
        this.rollCallProgressStatusDocumentRepository = rollCallProgressStatusDocumentRepository;
    }

    @Override
    public CreateRollCallCommandResult dispatch(CreateRollCallCommand command) {
        if (command.getOperator() == null) {
            throw new BadTenantException("\u64cd\u4f5c\u70b9\u540d\u7684\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(command.getSuperviseDepartIds()) && !StringUtils.hasLength((String)command.getOperator().getActionOrganizationId())) {
            throw new BadTenantException("\u76d1\u7ba1\u548c\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        List<RdEmployeeDocument> employeeDocuments = this.getMatchEmployees(command);
        if (CollectionUtils.isEmpty(employeeDocuments)) {
            throw new NoFoundTenantException("\u65e0\u9700\u70b9\u540d, \u627e\u4e0d\u5230\u4eba\u5458\u6570\u636e");
        }
        if (employeeDocuments.size() > 200) {
            logger.error("\u975e\u9884\u671f\u6570\u91cf(size={}); \u6f14\u793a\u8fc7\u7a0b\u4e2d, \u4e0d\u5141\u8bb8\u4e00\u6b21\u6027\u70b9\u540d\u8d85\u8fc7200\u4e2a\u4eba", (Object)employeeDocuments.size());
            throw new NoAllowedTenantException("\u975e\u9884\u671f\u6570\u91cf; \u6f14\u793a\u8fc7\u7a0b\u4e2d, \u4e0d\u5141\u8bb8\u4e00\u6b21\u6027\u70b9\u540d\u8d85\u8fc7200\u4e2a\u4eba");
        }
        Collection<String> stationIds = command.getSecurityStationIds();
        if (CollectionUtils.isEmpty(stationIds)) {
            stationIds = new HashSet<String>();
        }
        String tranId = this.unitWork.beginTransaction();
        RollCallEntity rollCall = RollCallEntity.create(this.jsonProvider, command.getOperator().getActionOrganizationId(), command.getOperator().getActionOrganizationName(), command.getOperator().getActionEmployeeId(), command.getOperator().getActionEmployeeName(), employeeDocuments.size(), this.idWorker.getNextId(), RollCallRulePoJo.create(command.getRollCallPlanId(), command.getTimeValue()), command.getSuperviseDepartIds(), stationIds, command.getStationTypes());
        try {
            this.rollCallRepository.insert(rollCall);
            ArrayList<ProducerRecord> records = new ArrayList<ProducerRecord>();
            ArrayList<RollCallEmployeeEntity> employees = new ArrayList<RollCallEmployeeEntity>();
            for (int index = 0; index < employeeDocuments.size(); ++index) {
                RdEmployeeDocument ii = employeeDocuments.get(index);
                String childId = String.format("%s-%s", rollCall.getId(), StringUtil.leftPad((String)String.valueOf(index + 1), (int)6));
                RollCallEmployeeEntity employeeEntity = RollCallEmployeeEntity.create(childId, this.jsonProvider, rollCall, ii.getTenantEmployeeId(), ii.getTenantUserId(), ii.getTenantImUserId(), ii.getName(), SecurityDepartPoJo.create(ii.getSuperviseDepartId(), ii.getSuperviseDepartName(), command.getOperator().getActionEmployeeId(), command.getOperator().getActionEmployeeName()), SecurityStationPoJo.create(ii.getSecurityStationId(), ii.getSecurityStationName(), BusinessUtil.isStationResponsible((String)ii.getSelectedResponsibleOfStationId(ii.getSecurityStationId())), command.getStationTypes()), OrganizationPoJo.create(ii.getOrganizationId(), ii.getCompanyName()));
                employees.add(employeeEntity);
                records.add(new ProducerRecord("dispatch.binlog-cdc.topic.v2.roll_call_record-v2", (Object)employeeEntity.getId(), (Object)this.jsonProvider.getJson((Object)employeeEntity)));
            }
            this.rollCallEmployeeRepository.batchInsert(employees);
            this.kafkaTemplate.execute(producer -> {
                try {
                    for (int index = 0; index < records.size(); ++index) {
                        ProducerRecord record = (ProducerRecord)records.get(index);
                        producer.send(record);
                    }
                }
                catch (Exception ex) {
                    throw new BadTenantException("\u63a8\u9001\u6570\u636e\u5230Kafka\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
                }
                return true;
            });
            if (command.getRollCallPlanId() == null) {
                this.rollCallProgressStatusDocumentRepository.save((Object)RollCallProgressStatusDocument.create((Long)rollCall.getId(), (int)employeeDocuments.size()));
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw new BadTenantException("\u63d0\u4ea4\u70b9\u540d\u4fe1\u606f\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
        return CreateRollCallCommandResult.create(rollCall.getId(), rollCall.getCountOfRollCallPerson());
    }

    @Override
    public void dispatch(BatchRollCallEmployeeCommand command) {
        if (CollectionUtils.isEmpty(command.getData())) {
            return;
        }
        Collection allRollCallEmployeeIds = command.getData().stream().map(ii -> (RollCallEmployeeEntity)((Object)((Object)this.jsonProvider.toObject(RollCallEmployeeEntity.class, ii)))).map(ii -> ii.getId()).distinct().collect(Collectors.toList());
        int retryIndex = 0;
        while (allRollCallEmployeeIds.size() > 0) {
            Collection<RollCallEmployeeEntity> callEmployees = this.rollCallEmployeeRepository.findByIds(allRollCallEmployeeIds);
            if (!CollectionUtils.isEmpty(callEmployees)) {
                StringBuilder error = new StringBuilder();
                String tranId = this.unitWork.beginTransaction();
                try {
                    Collection tenantUserIds = callEmployees.stream().map(ii -> ii.getCalledTenantUserId()).collect(Collectors.toSet());
                    Collection<TenantUserView> selectedTenantUsers = this.tenantUserViewRepository.getAllByIds(tenantUserIds);
                    Collection messageDocuments = callEmployees.stream().map(ii -> NotifyMessageDocument.create((JsonProvider)this.jsonProvider, (NotifyMessageType)NotifyMessageType.RollCall, (String)ii.getId(), (String)String.valueOf(ii.getRollCallId()), (String)ii.getCalledEmployeeId(), (MessageContentDocumentAbstract)RollCallMessageContentDocument.create((Long)ii.getRollCallId(), (String)ii.getActionOrganizationName(), (String)ii.getActionEmployeeName()))).collect(Collectors.toList());
                    this.notifyMessageDocumentRepository.saveAll((Iterable)messageDocuments);
                    HashSet<RollCallEmployeeHistoryEntity> histories = new HashSet<RollCallEmployeeHistoryEntity>();
                    for (RollCallEmployeeEntity ee : callEmployees) {
                        try {
                            String selectedCid = selectedTenantUsers.stream().filter(ii -> ii.getId().equalsIgnoreCase(ee.getCalledTenantUserId()) && StringUtils.hasLength((String)ii.getCid()) && !ii.getCid().contains("#")).map(ii -> ii.getCid()).findFirst().orElse(null);
                            ee.assignCalledTenantCid(selectedCid);
                            if (StringUtils.hasLength((String)selectedCid)) continue;
                            RollCallEmployeeHistoryEntity history = ee.assignFailed2Call(RollCallType.RollCall, RollCallStatus.RollCallFailed, "\u70b9\u540d\u5931\u8d25-\u8be5\u7528\u6237\u672a\u6fc0\u6d3b");
                            histories.add(history);
                        }
                        catch (Exception ex) {
                            this.unitWork.rollback(tranId);
                            error.append(String.format("rollCallId=%s;Employee=%s;\u5f02\u5e38=%s;", ee.getRollCallId(), ee.getCalledEmployeeId(), ExceptionUtil.getStackMessage((Throwable)ex)));
                            logger.error("Failed to roll call with BatchRollCallEmployeeCommand:rollCallId={};Employee={}", new Object[]{ee.getRollCallId(), ee.getCalledEmployeeId(), ex});
                        }
                    }
                    Collection validSelectedRollCallEmployees = callEmployees.stream().filter(ii -> StringUtils.hasLength((String)ii.getCalledTenantUserCid()) && ii.getCalledTenantUserCid().length() > 3).collect(Collectors.toList());
                    Collection selectedManuallyRollCallEmployees = callEmployees.stream().filter(ii -> ii.getRollCallPlanId() == null && !StringUtils.hasLength((String)ii.getCalledTenantUserCid())).collect(Collectors.toList());
                    try {
                        this.eventDispatcher.dispatch((DomainEvent)BatchDispatchRollCallEmployeeEvent.create(validSelectedRollCallEmployees));
                    }
                    catch (Exception ex) {
                        Collection badCallEmployees = validSelectedRollCallEmployees;
                        if (ex instanceof GeTuiBadTenantException) {
                            GeTuiBadTenantException gtException = (GeTuiBadTenantException)((Object)ex);
                            badCallEmployees = validSelectedRollCallEmployees.stream().filter(ii -> gtException.getDataItems().stream().anyMatch(ix -> ix.getCIds().contains(ii.getCalledTenantUserCid()))).collect(Collectors.toList());
                        }
                        for (RollCallEmployeeEntity ee : badCallEmployees) {
                            RollCallEmployeeHistoryEntity history = ee.assignFailed2Call(RollCallType.RollCall, RollCallStatus.RollCallFailed, "\u70b9\u540d-\u4e2a\u63a8\u6267\u884c\u5f02\u5e38");
                            histories.add(history);
                        }
                        selectedManuallyRollCallEmployees.addAll(badCallEmployees);
                    }
                    if (!CollectionUtils.isEmpty((Collection)selectedManuallyRollCallEmployees)) {
                        this.eventDispatcher.dispatch((DomainEvent)ReplyRollCallEmployeeStatusEvent.create(selectedManuallyRollCallEmployees));
                    }
                    this.rollCallEmployeeHistoryRepository.batchInsert(histories);
                    this.rollCallEmployeeRepository.batchUpdateStatusAndCId(callEmployees);
                    this.unitWork.commit(tranId);
                }
                catch (Exception ex) {
                    this.unitWork.rollback(tranId);
                    throw new BadTenantException(String.format("\u6279\u91cf\u5904\u7406\u70b9\u540d\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38:%s", error), (Throwable)ex);
                }
                allRollCallEmployeeIds = allRollCallEmployeeIds.stream().filter(ii -> !callEmployees.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
                logger.error("\u70b9\u540d\u8bb0\u5f55\u5904\u7406\u5b8c\u6210:{}", (Object)callEmployees.stream().map(ii -> ii.getId()).collect(Collectors.joining(",")));
            } else {
                logger.error("\u7b49\u5f85\u4e1a\u52a1({})\u63d0\u4ea4\u5230\u6570\u636e\u5e93....", (Object)allRollCallEmployeeIds.stream().collect(Collectors.joining(",")));
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (++retryIndex <= 30) continue;
            logger.error("RollCall Employee\u6570\u636e\u5904\u7406\u5f02\u5e38, \u5f02\u5e38\u6570\u636e\u4e3a:{}", (Object)allRollCallEmployeeIds.stream().map(ii -> String.format("'%s'", ii)).collect(Collectors.joining(",")));
        }
    }

    @Override
    public void dispatch(ReplyRollCallEmployeeStatusCommand command) {
        Collection<RollCallEmployeeEntity> rollCallEmployees = this.rollCallEmployeeRepository.findByRollCallIdAndEmployeeIds(command.getId(), command.getEmployeeIds());
        if (CollectionUtils.isEmpty(rollCallEmployees)) {
            logger.error("ReplyRollCallEmployeeStatusCommand: Failed to find the roll call employees with callId={} and empIds={}", (Object)command.getId(), (Object)command.getEmployeeIds().stream().collect(Collectors.joining(",")));
            return;
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            ArrayList<RollCallEmployeeHistoryEntity> employeeHistories = new ArrayList<RollCallEmployeeHistoryEntity>();
            for (RollCallEmployeeEntity ee : rollCallEmployees) {
                Collection<RollCallEmployeeHistoryEntity> histories = ee.reply(command.getCallType(), ee.getLastRoomId(), command.getCallStatus());
                employeeHistories.addAll(histories);
            }
            Collection selectedManuallyRollCallEmployees = rollCallEmployees.stream().filter(ii -> ii.getRollCallPlanId() == null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)selectedManuallyRollCallEmployees)) {
                this.eventDispatcher.dispatch((DomainEvent)ReplyRollCallEmployeeStatusEvent.create(selectedManuallyRollCallEmployees));
            }
            this.rollCallEmployeeHistoryRepository.batchInsert(employeeHistories);
            this.rollCallEmployeeRepository.batchUpdateStatusAndCId(rollCallEmployees);
            this.unitWork.commit(tranId);
        }
        catch (IgnoreTenantException ix) {
            this.unitWork.rollback(tranId);
            logger.error("Ignore exception: \u8be5\u8bf7\u6c42(RollCallId={},employeeIds={})\u5df2\u7ecf\u88ab\u786e\u8ba4\u8fc7; \u65e0\u9700\u91cd\u590d\u786e\u8ba4", (Object)command.getId(), (Object)command.getEmployeeIds().stream().collect(Collectors.joining(",")));
        }
        catch (TenantExceptionAbstract ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            logger.error("Failed to roll call with-ReplyRollCallEmployeeStatusCommand:{}-{}", new Object[]{command.getCallType(), command.getCallStatus(), ex});
            throw new BadTenantException("\u786e\u8ba4\u70b9\u540d\u4fe1\u606f-\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    @Override
    public void dispatch(RollCallBatchDispatchCommand command) {
        Collection rollCallIds = command.getItems().stream().map(ii -> ii.getRollCallId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)rollCallIds)) {
            return;
        }
        Collection employeeIds = command.getItems().stream().flatMap(ii -> ii.getEmployeeIds().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)employeeIds)) {
            return;
        }
        Collection<RollCallEmployeeEntity> rollCallEmployees = this.rollCallEmployeeRepository.findByRollCallIdsAndEmployeeIds(rollCallIds, employeeIds);
        if (CollectionUtils.isEmpty(rollCallEmployees)) {
            return;
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            HashSet<RollCallEmployeeHistoryEntity> employeeHistories = new HashSet<RollCallEmployeeHistoryEntity>();
            for (RollCallEmployeeEntity ree : rollCallEmployees) {
                String selectedRoomId;
                RollCallEmployeeHistoryEntity history = ree.doDispatch(selectedRoomId = (String)command.getItems().stream().filter(ii -> ii.getRollCallId().equals(ree.getRollCallId()) && ii.getEmployeeIds().contains(ree.getCalledEmployeeId())).map(ii -> ii.getRoomId()).findFirst().orElse(null));
                if (history == null) continue;
                employeeHistories.add(history);
            }
            if (!CollectionUtils.isEmpty(employeeHistories)) {
                this.rollCallEmployeeHistoryRepository.batchInsert(employeeHistories);
                this.rollCallEmployeeRepository.batchUpdateStatusAndCId(rollCallEmployees);
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            logger.error("Failed to roll call with-RollCallBatchDispatchCommand:{}", (Object)rollCallIds.stream().map(ii -> String.valueOf(ii)).collect(Collectors.joining(",")), (Object)ex);
            throw new BadTenantException("\u7763\u5bfc\u70b9\u540d\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    @Override
    public CancelRollCallEmployeeCommandResult dispatch(CancelRollCallEmployeeCommand command) {
        Collection<RollCallEmployeeEntity> selectedRollCallEmployees = this.rollCallEmployeeRepository.getTopNCanBeExpiredRecords(200, command.getCallStatus());
        if (!CollectionUtils.isEmpty(selectedRollCallEmployees)) {
            ArrayList<RollCallEmployeeHistoryEntity> employeeHistories = new ArrayList<RollCallEmployeeHistoryEntity>();
            for (RollCallEmployeeEntity ee : selectedRollCallEmployees) {
                Collection<RollCallEmployeeHistoryEntity> histories = ee.autoFailed(command.getCallStatus() == RollCallStatus.RollCallInit ? "\u81ea\u52a8\u70b9\u540d\u5931\u8d25" : "\u7763\u5bfc\u70b9\u540d\u5931\u8d25");
                if (histories == null) continue;
                employeeHistories.addAll(histories);
            }
            if (!CollectionUtils.isEmpty(employeeHistories)) {
                String tranId = this.unitWork.beginTransaction();
                try {
                    this.rollCallEmployeeRepository.batchUpdateStatusAndCId(selectedRollCallEmployees);
                    this.rollCallEmployeeHistoryRepository.batchInsert(employeeHistories);
                    Collection selectedManuallyRollCallEmployees = selectedRollCallEmployees.stream().filter(ii -> ii.getRollCallPlanId() == null).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty((Collection)selectedManuallyRollCallEmployees)) {
                        this.eventDispatcher.dispatch((DomainEvent)ReplyRollCallEmployeeStatusEvent.create(selectedManuallyRollCallEmployees));
                    }
                    this.unitWork.commit(tranId);
                }
                catch (Exception ex) {
                    this.unitWork.rollback(tranId);
                    logger.error("Failed to roll call with-CancelRollCallEmployeeCommand:{}", (Object)command.getCallStatus(), (Object)ex);
                    throw new BadTenantException("\u81ea\u52a8\u70b9\u540d\u5931\u8d25\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
                }
            }
        }
        return CancelRollCallEmployeeCommandResult.create(selectedRollCallEmployees.stream().map(ii -> CancelRollCallEmployeeCommandResult.CancelRollCallEmployeeCommandItem.create(ii.getId(), ii.getStatus())).collect(Collectors.toList()));
    }

    @Override
    public void dispatch(RollCallBatchEmployeeRoomActionCommand command) {
        if (CollectionUtils.isEmpty(command.getItems())) {
            return;
        }
        Collection employeeIds = command.getItems().stream().map(ii -> ii.getEmployeeId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)employeeIds)) {
            return;
        }
        Collection rollCallIds = command.getItems().stream().map(ii -> ii.getRollCallId()).collect(Collectors.toList());
        Collection<RollCallEmployeeEntity> rollCallEmployees = this.rollCallEmployeeRepository.findByRollCallIdsAndEmployeeIds(rollCallIds, employeeIds);
        if (CollectionUtils.isEmpty(rollCallEmployees)) {
            return;
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            ArrayList<RollCallEmployeeHistoryEntity> employeeHistories = new ArrayList<RollCallEmployeeHistoryEntity>();
            for (RollCallEmployeeEntity ee : rollCallEmployees) {
                RollCallBatchEmployeeRoomActionCommand.RollCallReplyEmployeeCommandItem rollCallReplyEmployeeCommandItem = command.getItems().stream().filter(ii -> ii.getRollCallId().equals(ee.getRollCallId()) && ii.getEmployeeId().equals(ee.getCalledEmployeeId())).findFirst().orElse(null);
                if (rollCallReplyEmployeeCommandItem == null) {
                    throw new BadTenantException("\u5f02\u5e38\u53c2\u6570\u4fe1\u606f: rollCallStatus=null");
                }
                Collection<RollCallEmployeeHistoryEntity> histories = ee.reply(RollCallType.Dispatch, StringUtils.hasLength((String)ee.getLastRoomId()) ? ee.getLastRoomId() : rollCallReplyEmployeeCommandItem.getRoomId(), rollCallReplyEmployeeCommandItem.getCallStatus());
                employeeHistories.addAll(histories);
            }
            this.rollCallEmployeeHistoryRepository.batchInsert(employeeHistories);
            this.rollCallEmployeeRepository.batchUpdateStatusAndCId(rollCallEmployees);
            Collection instantActiveDocIds = command.getItems().stream().map(ii -> ii.getInstantActiveDocId()).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)instantActiveDocIds)) {
                this.instantActivityDataDocumentRepository.deleteAllById((Iterable)instantActiveDocIds);
            }
            this.unitWork.commit(tranId);
        }
        catch (TenantExceptionAbstract ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw new BadTenantException("\u786e\u8ba4\u70b9\u540d\u4fe1\u606f-\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private List<RdEmployeeDocument> getMatchEmployees(CreateRollCallCommand command) {
        Collection<String> selectedStationIds;
        SearchStream searchStream = this.entityStream.of(RdEmployeeDocument.class);
        if (command.getOperator() == null) {
            throw new BadTenantException(String.format("\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38(planId=%s), \u64cd\u4f5c\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", command.getRollCallPlanId()));
        }
        command.getOperator().validate();
        searchStream = DocumentScopeFilterUtils.basicFilterEmployee((SearchStream)searchStream, (String)command.getOperator().getActionOrgInstitutional(), (String)command.getOperator().getActionOrganizationId(), (String)command.getOperator().getActionOrganizationName(), command.getSuperviseDepartIds());
        if (!CollectionUtils.isEmpty(command.getStationTypes())) {
            SearchStream securityStationDocumentSearchStream = this.entityStream.of(RdSecurityStationDocument.class);
            securityStationDocumentSearchStream = DocumentScopeFilterUtils.basicFilterStation((SearchStream)securityStationDocumentSearchStream, (String)command.getOperator().getActionOrgInstitutional(), (String)command.getOperator().getActionOrganizationId(), command.getSuperviseDepartIds());
            String[] stationTypes = (String[])command.getStationTypes().toArray(String[]::new);
            securityStationDocumentSearchStream = securityStationDocumentSearchStream.filter((Predicate)RdEmployeeDocument$.STATION_TYPES.in(stationTypes));
            if (!CollectionUtils.isEmpty(command.getSecurityStationIds())) {
                String[] stationIds = (String[])command.getSecurityStationIds().toArray(String[]::new);
                securityStationDocumentSearchStream = securityStationDocumentSearchStream.filter((SearchFieldPredicate)RdSecurityStationDocument$.ID.in(stationIds));
            }
            Collection selectedStationIds2 = new HashSet();
            selectedStationIds2 = ((List)securityStationDocumentSearchStream.collect(Collectors.toList())).stream().map(ii -> ii.getId()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(selectedStationIds2)) {
                return Collections.EMPTY_LIST;
            }
            String[] stationIds = (String[])selectedStationIds2.toArray(String[]::new);
            searchStream = searchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.in(stationIds));
        } else if (!CollectionUtils.isEmpty(command.getSecurityStationIds()) && !CollectionUtils.isEmpty(selectedStationIds = command.getSecurityStationIds())) {
            String[] stationIds = (String[])selectedStationIds.toArray(String[]::new);
            searchStream = searchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.in(stationIds));
        }
        return (List)searchStream.limit(1000000L).collect(Collectors.toList());
    }

    private List<RollCallEmployeeEntity> getMatchValidBatchEmployees(Collection<String> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        Collection callEmployees = data.stream().map(ii -> (RollCallEmployeeEntity)((Object)((Object)this.jsonProvider.toObject(RollCallEmployeeEntity.class, ii)))).collect(Collectors.toList());
        Collection rollCallIds = callEmployees.stream().map(ii -> ii.getRollCallId()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)rollCallIds)) {
            return Collections.EMPTY_LIST;
        }
        Collection<RollCallEntity> existRollCalls = this.rollCallRepository.getByIds(rollCallIds);
        Collection existsRollCallIds = existRollCalls.stream().map(ii -> ii.getId()).collect(Collectors.toList());
        Collection notExistRollCallIds = rollCallIds.stream().filter(ii -> !existsRollCallIds.stream().anyMatch(ix -> ix.equals(ii))).collect(Collectors.toList());
        for (int retryIndex = 0; notExistRollCallIds.size() > 0 && retryIndex < 10; ++retryIndex) {
            try {
                Thread.sleep(100L);
                logger.error("\u6b63\u5728\u5904\u7406RollCall\u6570\u636e({}); \u7b49\u5f85\u91cd\u8bd5\u4e2d...", (Object)notExistRollCallIds.stream().map(ii -> String.valueOf(ii)).collect(Collectors.joining(",")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            existRollCalls = this.rollCallRepository.getByIds(notExistRollCallIds);
            existsRollCallIds.addAll(existRollCalls.stream().map(ii -> ii.getId()).collect(Collectors.toList()));
            rollCallIds.stream().filter(ii -> !existsRollCallIds.stream().anyMatch(ix -> ix.equals(ii))).collect(Collectors.toList());
        }
        Collection finalExistRollCalls = existsRollCallIds;
        return callEmployees.stream().filter(ii -> finalExistRollCalls.stream().anyMatch(ix -> ix.equals(ii.getRollCallId()))).collect(Collectors.toList());
    }
}

