/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@Schema(name="ProjectOverviewResponse", title="\u8fd4\u56de\u9879\u76ee\u4fe1\u606f")
public class ProjectOverviewResponse
extends ResponseAbstract {
    @Schema(name="id", title="id")
    private final String id;
    @Schema(name="name", title="\u9879\u76ee\u540d\u79f0")
    private final String name;
    @Schema(name="statusLabel", title="\u72b6\u6001")
    private final String statusLabel;
    private Set<String> scopePermissions;
    @Schema(name="beginDate", title="\u5f00\u59cb\u65f6\u95f4")
    private final String beginDate;
    @Schema(name="endDate", title="\u7ed3\u675f\u65f6\u95f4")
    private final String endDate;
    private final boolean valid;

    public ProjectOverviewResponse(String id, String name, String beginDateValue, String endDateValue) {
        this.id = id;
        this.name = name;
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("M/d/yy, HH:mm");
        Date beginDt = null;
        if (beginDateValue != null) {
            try {
                beginDt = dateFormat.parse(beginDateValue);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(beginDt);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                beginDt = calendar.getTime();
            }
            catch (Exception calendar) {
                // empty catch block
            }
        }
        Date endDt = null;
        if (endDateValue != null) {
            try {
                endDt = dateFormat.parse(endDateValue);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDt);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(5, 1);
                endDt = calendar.getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (beginDt != null && beginDt.after(now)) {
            this.statusLabel = "\u672a\u5f00\u59cb";
            this.valid = true;
        } else if (endDt != null && endDt.before(now)) {
            this.statusLabel = "\u5df2\u7ed3\u675f";
            this.valid = false;
        } else {
            this.statusLabel = "\u8fdb\u884c\u4e2d";
            this.valid = true;
        }
        this.beginDate = beginDateValue;
        this.endDate = endDateValue;
    }

    public static ProjectOverviewResponse create(String id, String name, String beginDate, String endDate) {
        return new ProjectOverviewResponse(id, name, beginDate, endDate);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStatusLabel() {
        return this.statusLabel;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }
}

