/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.signature.config.FileModeConfig;
import com.bcxin.signature.util.ThreadUtil;
import com.bcxin.signature.util.ftp.DownloadResult;
import com.bcxin.signature.util.ftp.DownloadTask;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpFactory;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);

    /*
     * WARNING - void declaration
     */
    public static synchronized List<DownloadResult> download(String ftpPath, String[] listFileName) {
        void var7_9;
        String cont = "";
        ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(FileModeConfig.threadPoolSize);
        ArrayList results = new ArrayList();
        String[] stringArray = listFileName;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String fileName = stringArray[var7_9];
            DownloadTask upload = new DownloadTask(null, null, ftpPath, fileName);
            Future submit = newFixedThreadPool.submit(upload);
            results.add(submit);
            ++var7_9;
        }
        ArrayList<DownloadResult> listResults = new ArrayList<DownloadResult>();
        for (Future future : results) {
            try {
                DownloadResult uploadResult = (DownloadResult)future.get(15L, TimeUnit.SECONDS);
                System.err.println("=======>    FTP download DownloadResult\uff1a" + StringUtils.isNotEmpty((CharSequence)uploadResult.getContent()) + "   <=======");
                listResults.add(uploadResult);
            }
            catch (Exception e) {
                if (StringUtils.isEmpty((CharSequence)cont) && e.getMessage().contains("SocketException: Broken pipe")) {
                    cont = e.getMessage();
                }
                System.err.println("=======>\u7ebf\u7a0b\u6c60\u4e0b\u8f7dftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
            }
        }
        newFixedThreadPool.shutdown();
        if (StringUtils.isNotEmpty((CharSequence)cont)) {
            listResults = null;
        }
        return listResults;
    }

    public static boolean uploadBase64(String ftpPath, String ftpFileName, String base64Content) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.uploadBase64(ftpPath, ftpFileName, base64Content);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0a\u4f20base64\u6587\u4ef6\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static boolean downloadFile(String path, String filename, File dstFile) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.download(path, filename, dstFile);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static String downloadAsBase64(String path, String filename) {
        String result = "";
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.downloadAsBase64(path, filename);
        }
        catch (IOException e) {
            System.err.println("=======>\u4e0b\u8f7d\u6587\u4ef6\u8f93\u51fabase64\u5931\u8d25ftp\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
        return result;
    }

    public static List<String> filenames(String path, String keywork) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.fileNames(path, keywork);
        }
        catch (IOException e) {
            System.err.println("=======>\u83b7\u53d6ftp\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6587\u4ef6\u540d\uff1a" + e.getMessage() + "<=======");
            return new ArrayList<String>();
        }
    }

    public static boolean delFilename(String path, String filename) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.delectFile(path, filename);
        }
        catch (IOException e) {
            logger.error("delete the ftp file:path={},filename={}", new Object[]{path, filename, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String path, String ftpFileName) {
        FtpConnection ftp = new FtpConnection();
        for (int retryIndex = 0; retryIndex < 5; ++retryIndex) {
            SocketException lastSocketException = null;
            try {
                String content;
                String string = content = ftp.getFileContent(path, ftpFileName);
                return string;
            }
            catch (SocketException ex) {
                logger.error("SECURITY-ERROR-getFileContent-IO: get ftp file(path={},fileName={})exception", new Object[]{path, ftpFileName, ex});
                lastSocketException = ex;
                ThreadUtil.sleep((long)300L);
                continue;
            }
            catch (Exception e) {
                logger.error("SECURITY-ERROR-getFileContent: get ftp file(path={},fileName={})exception", new Object[]{path, ftpFileName, e});
                continue;
            }
            finally {
                if (lastSocketException == null) {
                    try {
                        ftp.delectFile(path, ftpFileName);
                    }
                    catch (Exception ex) {
                        logger.error("failed to delete file:path={};fileName={}", (Object)path, (Object)ftpFileName);
                    }
                }
                try {
                    ftp.disconnect();
                }
                catch (IOException e) {
                    logger.error("disconnect ftp exception", (Throwable)e);
                }
            }
        }
        return "";
    }

    public static String getFileContent(FtpConnection ftp, String path, String ftpFileName) {
        try {
            return ftp.getFileContent(path, ftpFileName);
        }
        catch (Exception e) {
            logger.error("fail to get ftp file(path={},fileName={}) with exception", new Object[]{path, ftpFileName, e});
            throw new RuntimeException("failed to get fileContent", e);
        }
    }

    public static void disConnect(FtpConnection ftp, String path, String ftpFileName) {
        try {
            ftp.delectFile(path, ftpFileName);
            ftp.disconnect();
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6ftp\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Collection<String> getFtpMetaFiles(FtpConnection ftp) {
        return FtpUtil.getFiles((FtpConnection)ftp, (String)"INJTLZ-", (int)20);
    }

    public static Collection<String> getDirectlyFiles(FtpConnection ftp, String filePrefix) {
        return ftp.getMetaFileNames(filePrefix, 60);
    }

    public static Collection<String> getFiles(FtpConnection ftp, String filePrefix, int limit) {
        return ftp.getMetaFileNames(filePrefix, limit);
    }
}

