/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import com.bcxin.signature.util.ftp.DownloadResult;
import com.bcxin.signature.util.ftp.FtpConnection;
import com.bcxin.signature.util.ftp.FtpFactory;
import java.io.IOException;
import java.util.concurrent.Callable;

public class DownloadTask
implements Callable {
    private FtpConnection ftp;
    private String path;
    private String fileName;
    private FtpFactory factory;

    public DownloadTask(FtpFactory factory, FtpConnection ftp, String path, String fileName) {
        this.factory = factory;
        this.ftp = ftp;
        this.path = path;
        this.fileName = fileName;
    }

    public DownloadResult call() throws Exception {
        DownloadResult result = null;
        try {
            this.ftp = new FtpConnection();
            result = new DownloadResult(this.fileName, this.ftp.getFileContent(this.path, this.fileName));
        }
        catch (IOException ex) {
            result = new DownloadResult(this.fileName, "");
            ex.printStackTrace();
        }
        finally {
            try {
                this.ftp.delectFile(this.path, this.fileName);
                if (this.factory != null) {
                    this.factory.relase(this.ftp);
                }
            }
            catch (Exception e) {
                System.out.println("===ERR===>  ftp download delete file fail,fileName:" + this.fileName);
            }
        }
        return result;
    }
}

